/* BPDConfig.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：BPD主界面自定义信息配置类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import com.ds.bpm.bpd.xml.XML;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.Properties;

/**
 * The singlton class used to hold the current BPD configuration. First, the properties are set to default values in the
 * property map (all properties are given in their String representation). After that, the properties are retrieved from
 * BPD.conf file, checked for its validity, and if they have valid values, they replaces the default properties. Class
 * has method for setting and getting all of it's properties.
 */
public final class BPDConfig {
    // Minimal values for some properties
    private static final int MIN_PROCESS_WIDTH = 75;

    private static final int MIN_PROCESS_HEIGHT = 45;

    private static final int MIN_MIN_PARTICIPANT_WIDTH = 535;

    private static final int MIN_MIN_PARTICIPANT_HEIGHT = 50;

    private static final int MIN_PARTICIPANT_NAME_WIDTH = 25;

    private static final int MIN_ACTIVITY_WIDTH = 50;

    private static final int MIN_ACTIVITY_HEIGHT = 30;

    private static final int MIN_GRID_SIZE = 4;

    public static final String ON_STATUS = "ON";

    public static final String OFF_STATUS = "OFF";

    // default values for all properties
    public static final String CURRENT_VERSION = "1.0";

    public static final String DEFAULT_STARTING_LOCALE = "";

    public static final String DEFAULT_MANDATORY_CONFORMANCE_CLASS_SETTING_STATUS = "ON";

    public static final String DEFAULT_MANDATORY_CONFORMANCE_CLASS = "FULL_BLOCKED";

    public static final String DEFAULT_VALIDATION_STATUS = ON_STATUS;

    public static final String DEFAULT_LOOK_AND_FEEL_CLASS_NAME = "com.birosoft.liquid.LiquidLookAndFeel";

    public static final String DEFAULT_RECENT_FILE_LIST_SIZE = "10";

    public static final String DEFAULT_TOOLTIP_STATUS = ON_STATUS;

    public static final String DEFAULT_GRID_STATUS = ON_STATUS;

    public static final String DEFAULT_STATUS_BAR_STATUS = ON_STATUS;

    public static final String DEFAULT_LDAP_COUNT_LIMIT = "0";

    public static final String DEFAULT_LDAP_TIME_LIMIT = "0";

    public static final String DEFAULT_GRID_SIZE = "10";

    public static final String DEFAULT_PROCESS_WIDTH = "135";

    public static final String DEFAULT_PROCESS_HEIGHT = "65";

    public static final String DEFAULT_MIN_PARTICIPANT_WIDTH = "800";

    public static final String DEFAULT_MIN_PARTICIPANT_HEIGHT = "150";

    public static final String DEFAULT_PARTICIPANT_NAME_WIDTH = "10";

    public static final String DEFAULT_ACTIVITY_WIDTH = "75";

    public static final String DEFAULT_ACTIVITY_HEIGHT = "40";

    public static final String DEFAULT_BACKGROUND_COLOR = "SystemColor.menu";

    public static final String DEFAULT_HIGHLIGHT_COLOR = "SystemColor.inactiveCaptionText";

    public static final String DEFAULT_HANDLE_COLOR = "Color.pink";

    public static final String DEFAULT_MARQUEE_COLOR = "Color.black";

    public static final String DEFAULT_GRID_COLOR = "SystemColor.textHighlight";

    public static final String DEFAULT_PROCESS_COLOR = "R=58,G=110,B=165";

    public static final String DEFAULT_TRANSITION_COLOR = "Color.black";

    public static final String DEFAULT_BACKWARDTRANSITION_COLOR = "R=51,G=153,B=255";

    public static final String DEFAULT_PARTICIPANT_TEXT_COLOR = "Color.white";

    public static final String DEFAULT_PARTICIPANT_BORDER_COLOR = "Color.white";

    public static final String DEFAULT_RESOURCE_SET_PARTICIPANT_COLOR = "Color.white";

    public static final String DEFAULT_RESOURCE_PARTICIPANT_COLOR = "R=146,G=146,B=160";

    public static final String DEFAULT_ROLE_PARTICIPANT_COLOR = "R=146,G=180,B=146";

    public static final String DEFAULT_ORGANIZATIONAL_UNIT_PARTICIPANT_COLOR = "R=180,G=146,B=146";

    public static final String DEFAULT_HUMAN_PARTICIPANT_COLOR = "R=160,G=146,B=146";

    public static final String DEFAULT_SYSTEM_PARTICIPANT_COLOR = "R=146,G=160,B=146";

    public static final String DEFAULT_FREE_TEXT_EXPRESSION_PARTICIPANT_COLOR = "SystemColor.text";

    public static final String DEFAULT_SELECTED_ACTIVITY__COLOR = "Color.orange";

    public static final String DEFAULT_START_COLOR = "R=135,G=174,B=252";

    public static final String DEFAULT_END_COLOR = "R=255,G=204,B=255";

    public static final String DEFAULT_MANUAL_ACTIVITY_COLOR = "R=204,G=204,B=255";

    public static final String DEFAULT_AUTO_ACTIVITY_COLOR = "R=216,G=230,B=216";

    public static final String DEFAULT_DEVICE_ACTIVITY_COLOR = "R=196,G=196,B=196";

    public static final String DEFAULT_EVENT_ACTIVITY_COLOR = "R=146,G=180,B=146";

    public static final String DEFAULT_SERVICE_ACTIVITY_COLOR = "R=150,G=218,B=222";

    public static final String DEFAULT_SUBFLOW_ACTIVITY_COLOR = "R=230,G=216,B=216";

    public static final String DEFAULT_OUTFLOW_ACTIVITY_COLOR = "R=222,G=230,B=129";

    public static final String DEFAULT_BLOCK_ACTIVITY_COLOR = "R=216,G=216,B=230";

    public static final String DEFAULT_ACTIVITY_PRECONDITION_COLOR = "Color.black";

    public static final String DEFAULT_ACTIVITY_POSTCONDITION_COLOR = "Color.red";

    // 设置图形面板背景色
    public static final String DEFAULT_GRAPHBACKGROUND_COLOR = "Color.white";

    // 流程树型列表是否展开
    public static final String DEFAULT_JTREEEXPAND_STATUS = ON_STATUS;

    // 远端服务器设置
    public static final String DEFAULT_SERVER_NAME = "localhost";

    public static final String DEFAULT_SERVER_PORT = "80";

    public static final String DEFAULT_USER_NAME = "anonymous";

    // one and only instance of BPDConfig class
    private static BPDConfig bpdConfig;

    public static final String DEFAULT_ENCODING = "UTF-8";

    // Configuration filename
    private String cfn;

    private Properties properties = new Properties();

    private XML xmlInterface;

    static {
	bpdConfig = new BPDConfig();
    }

    public static BPDConfig getInstance() {
	return bpdConfig;
    }

    private BPDConfig() {
	this.xmlInterface = new XML();
	setDefaultValues();
	// remove version, so we can see if user uses an old version of
	// the config file, and then we'll warn him and overwrite
	properties.remove("Version");
	// reading the property values from config. file, the default values
	// are overriden if they are found within conf file
	cfn = BPDConstants.BPD_USER_HOME + BPDConstants.BPD_CONF_FILENAME;

	// first try to find the conf file at the default location
		InputStream is =null;
		try {
	     is = new FileInputStream(cfn);
	    properties.load(is);
	    initialize();
	    String ver = properties.getProperty("Version");
	    // if this is the new version of BPD, save new conf file
	    if (ver == null || !ver.equals(CURRENT_VERSION)) {
		properties.setProperty("Version", CURRENT_VERSION);
		saveConf();
	    }
	    // if there is no conf file, create new and load default settings
	} catch (Exception ex) {
	    // get bach the version
	    properties.setProperty("Version", CURRENT_VERSION);
	    initialize();
	    saveConf();
	}
    }

    private void setDefaultValues() {
	// setting default property values
	properties.setProperty("Version", CURRENT_VERSION);
	properties.setProperty("StartingLocale", DEFAULT_STARTING_LOCALE);
	// properties.setProperty("MandatoryConformanceClassSettingStatus",
	// DEFAULT_MANDATORY_CONFORMANCE_CLASS_SETTING_STATUS);
	// properties.setProperty("MandatoryConformanceClass",
	// DEFAULT_MANDATORY_CONFORMANCE_CLASS);
	properties.setProperty("ValidationStatus", DEFAULT_VALIDATION_STATUS);
	properties.setProperty("LookAndFeelClassName", DEFAULT_LOOK_AND_FEEL_CLASS_NAME);
	properties.setProperty("RecentFileListSize", DEFAULT_RECENT_FILE_LIST_SIZE);
	properties.setProperty("TooltipStatus", DEFAULT_TOOLTIP_STATUS);
	// properties.setProperty("GridStatus", DEFAULT_GRID_STATUS);
	properties.setProperty("StatusBarStatus", DEFAULT_STATUS_BAR_STATUS);
	// properties.setProperty("GridSize", DEFAULT_GRID_SIZE);
	// properties.setProperty("LDAPCountLimit", DEFAULT_LDAP_COUNT_LIMIT);
	// properties.setProperty("LDAPTimeLimit", DEFAULT_LDAP_TIME_LIMIT);
	// properties.setProperty("ProcessWidth",DEFAULT_PROCESS_WIDTH);
	// properties.setProperty("ProcessHeight",DEFAULT_PROCESS_HEIGHT);
	// properties.setProperty("MinParticipantWidth",DEFAULT_MIN_PARTICIPANT_WIDTH);
	// properties.setProperty("MinParticipantHeight",DEFAULT_MIN_PARTICIPANT_HEIGHT);
	// properties.setProperty("ParticipantNameWidth",DEFAULT_PARTICIPANT_NAME_WIDTH);
	properties.setProperty("ActivityWidth", DEFAULT_ACTIVITY_WIDTH);
	properties.setProperty("ActivityHeight", DEFAULT_ACTIVITY_HEIGHT);
	properties.setProperty("BackgroundColor", DEFAULT_BACKGROUND_COLOR);
	properties.setProperty("HighlightColor", DEFAULT_HIGHLIGHT_COLOR);
	properties.setProperty("HandleColor", DEFAULT_HANDLE_COLOR);
	properties.setProperty("MarqueeColor", DEFAULT_MARQUEE_COLOR);

	// properties.setProperty("GridColor", DEFAULT_GRID_COLOR);
	// properties.setProperty("ProcessColor",DEFAULT_PROCESS_COLOR);
	properties.setProperty("TransitionColor", DEFAULT_TRANSITION_COLOR);
	properties.setProperty("BackwardTransitionColor", DEFAULT_BACKWARDTRANSITION_COLOR);
	/*
	 * properties.setProperty("ParticipantTextColor",DEFAULT_PARTICIPANT_TEXT_COLOR);
	 * properties.setProperty("ParticipantBorderColor",DEFAULT_PARTICIPANT_BORDER_COLOR);
	 * properties.setProperty("ResourceSetParticipantColor",DEFAULT_RESOURCE_SET_PARTICIPANT_COLOR);
	 * properties.setProperty("ResourceParticipantColor",DEFAULT_RESOURCE_PARTICIPANT_COLOR);
	 * properties.setProperty("RoleParticipantColor",DEFAULT_ROLE_PARTICIPANT_COLOR);
	 * properties.setProperty("OrganizationalUnitParticipantColor",DEFAULT_ORGANIZATIONAL_UNIT_PARTICIPANT_COLOR);
	 * properties.setProperty("HumanParticipantColor",DEFAULT_HUMAN_PARTICIPANT_COLOR);
	 * properties.setProperty("SystemParticipantColor",DEFAULT_SYSTEM_PARTICIPANT_COLOR);
	 * properties.setProperty("FreeTextExpressionParticipantColor",DEFAULT_FREE_TEXT_EXPRESSION_PARTICIPANT_COLOR);
	 */
	properties.setProperty("StartColor", DEFAULT_START_COLOR);
	properties.setProperty("EndColor", DEFAULT_END_COLOR);
	properties.setProperty("SelectedActivityColor", DEFAULT_SELECTED_ACTIVITY__COLOR);
	properties.setProperty("ManualActivityColor", DEFAULT_MANUAL_ACTIVITY_COLOR);
	properties.setProperty("AutoActivityColor", DEFAULT_AUTO_ACTIVITY_COLOR);
	properties.setProperty("DeviceActivityColor", DEFAULT_DEVICE_ACTIVITY_COLOR);
	properties.setProperty("EventActivityColor", DEFAULT_EVENT_ACTIVITY_COLOR);

	properties.setProperty("ServiceActivityColor", DEFAULT_SERVICE_ACTIVITY_COLOR);
	properties.setProperty("SubFlowActivityColor", DEFAULT_SUBFLOW_ACTIVITY_COLOR);
	properties.setProperty("BlockActivityColor", DEFAULT_BLOCK_ACTIVITY_COLOR);
	properties.setProperty("OutFlowActivityColor", DEFAULT_OUTFLOW_ACTIVITY_COLOR);

	properties.setProperty("ActivityPreconditionColor", DEFAULT_ACTIVITY_PRECONDITION_COLOR);
	properties.setProperty("ActivityPostconditionColor", DEFAULT_ACTIVITY_POSTCONDITION_COLOR);
	// 设置图形面板背景色
	properties.setProperty("GraphBackgroundColor", DEFAULT_GRAPHBACKGROUND_COLOR);

	properties.setProperty("JTreeExpandStatus", DEFAULT_JTREEEXPAND_STATUS);

	// ##############设置远端服务器参数##################
	properties.setProperty("ServerName", DEFAULT_SERVER_NAME);
	properties.setProperty("ServerPort", DEFAULT_SERVER_PORT);
	properties.setProperty("UserName", DEFAULT_USER_NAME);
    }

    private void initialize() {
	// setting starting locale
	setStartingLocale(properties.getProperty("StartingLocale"));

	/*
	 * // setting mandatory conformance setting status boolean mccst; try { String mccsts =
	 * properties.getProperty("MandatoryConformanceClassSettingStatus"); if (mccsts.equalsIgnoreCase(OFF_STATUS)) {
	 * mccst = false; } else { mccst = true; } } catch (Exception ex) { if
	 * (DEFAULT_MANDATORY_CONFORMANCE_CLASS_SETTING_STATUS.equalsIgnoreCase(ON_STATUS)) { mccst = true; } else {
	 * mccst = false; } } setMandatoryConformanceClassSettingStatus(mccst); // setting mandatory conformance level
	 * setMandatoryConformanceClass(properties.getProperty("MandatoryConformanceClass"));
	 */

	// setting validation status
	boolean vst;
	try {
	    String vsts = properties.getProperty("ValidationStatus");
	    if (vsts.equalsIgnoreCase(OFF_STATUS)) {
		vst = false;
	    } else {
		vst = true;
	    }
	} catch (Exception ex) {
	    if (DEFAULT_VALIDATION_STATUS.equalsIgnoreCase(ON_STATUS)) {
		vst = true;
	    } else {
		vst = false;
	    }
	}
	setValidationStatus(vst);

	// setting L&F
	setLookAndFeelClassName(properties.getProperty("LookAndFeelClassName"));

	// setting recent file list size
	int rfls;
	try {
	    rfls = Integer.parseInt(properties.getProperty("RecentFileListSize"));
	} catch (Exception ex) {
	    rfls = Integer.parseInt(DEFAULT_RECENT_FILE_LIST_SIZE);
	}
	setRecentFileListSize(rfls);

	// setting tooltip status
	boolean tst;
	try {
	    String tss = properties.getProperty("TooltipStatus");
	    if (tss.equalsIgnoreCase(OFF_STATUS)) {
		tst = false;
	    } else {
		tst = true;
	    }
	} catch (Exception ex) {
	    if (DEFAULT_TOOLTIP_STATUS.equalsIgnoreCase(ON_STATUS)) {
		tst = true;
	    } else {
		tst = false;
	    }
	}
	setTooltipStatus(tst);

	// 设置流程树型列表的是否展开
	boolean jtest;
	try {
	    String jtess = properties.getProperty("JTreeExpandStatus");
	    if (jtess.equalsIgnoreCase(OFF_STATUS)) {
		jtest = false;
	    } else {
		jtest = true;
	    }
	} catch (Exception ex) {
	    if (DEFAULT_JTREEEXPAND_STATUS.equalsIgnoreCase(ON_STATUS)) {
		jtest = true;
	    } else {
		jtest = false;
	    }
	}
	setJTreeExpandStatus(jtest);

	/*
	 * // setting grid status boolean gst; try { String gss = properties.getProperty("GridStatus"); if
	 * (gss.equalsIgnoreCase(OFF_STATUS)) { gst = false; } else { gst = true; } } catch (Exception ex) { if
	 * (DEFAULT_GRID_STATUS.equalsIgnoreCase(ON_STATUS)) { gst = true; } else { gst = false; } } setGridStatus(gst);
	 */

	// setting statusbar status
	boolean sbst;
	try {
	    String sbss = properties.getProperty("StatusBarStatus");
	    if (sbss.equalsIgnoreCase(OFF_STATUS)) {
		sbst = false;
	    } else {
		sbst = true;
	    }
	} catch (Exception ex) {
	    if (DEFAULT_STATUS_BAR_STATUS.equalsIgnoreCase(ON_STATUS)) {
		sbst = true;
	    } else {
		sbst = false;
	    }
	}
	setStatusBarStatus(sbst);

	/*
	 * // setting LDAP properties int lcl; try { lcl = Integer.parseInt(properties.getProperty("LDAPCountLimit")); }
	 * catch (Exception ex) { lcl = Integer.parseInt(DEFAULT_LDAP_COUNT_LIMIT); } setLDAPCountLimit(lcl); int ltl;
	 * try { ltl = Integer.parseInt(properties.getProperty("LDAPTimeLimit")); } catch (Exception ex) { ltl =
	 * Integer.parseInt(DEFAULT_LDAP_TIME_LIMIT); } setLDAPTimeLimit(ltl); // setting grid size int gs; try { gs =
	 * Integer.parseInt(properties.getProperty("GridSize")); } catch (Exception ex) { gs =
	 * Integer.parseInt(DEFAULT_GRID_SIZE); } setGridSize(gs);
	 */

	// setting process dimensions read from conf file
	/*
	 * int pWidth, pHeight; try { pWidth = Integer.parseInt(properties.getProperty("ProcessWidth")); } catch
	 * (Exception ex) { pWidth = Integer.parseInt(DEFAULT_PROCESS_WIDTH); } setProcessWidth(pWidth); try { pHeight =
	 * Integer.parseInt(properties.getProperty("ProcessHeight")); } catch (Exception ex) { pHeight =
	 * Integer.parseInt(DEFAULT_PROCESS_HEIGHT); } setProcessHeight(pHeight); // setting participant dimensions read
	 * from conf file int mpWidth, mpHeight, pnWidth; try { mpWidth =
	 * Integer.parseInt(properties.getProperty("MinParticipantWidth")); } catch (Exception ex) { mpWidth =
	 * Integer.parseInt(DEFAULT_MIN_PARTICIPANT_WIDTH); } setMinParticipantWidth(mpWidth); try { mpHeight =
	 * Integer.parseInt(properties.getProperty("MinParticipantHeight")); } catch (Exception ex) { mpHeight =
	 * Integer.parseInt(DEFAULT_MIN_PARTICIPANT_HEIGHT); } setMinParticipantHeight(mpHeight); try { pnWidth =
	 * Integer.parseInt(properties.getProperty("ParticipantNameWidth")); } catch (Exception ex) { pnWidth =
	 * Integer.parseInt(DEFAULT_PARTICIPANT_NAME_WIDTH); } setParticipantNameWidth(pnWidth);
	 */

	// setting activity dimensions read from conf file
	int aWidth, aHeight;
	try {
	    aWidth = Integer.parseInt(properties.getProperty("ActivityWidth"));
	} catch (Exception ex) {
	    aWidth = Integer.parseInt(DEFAULT_ACTIVITY_WIDTH);
	}
	setActivityWidth(aWidth);
	try {
	    aHeight = Integer.parseInt(properties.getProperty("ActivityHeight"));
	} catch (Exception ex) {
	    aHeight = Integer.parseInt(DEFAULT_ACTIVITY_HEIGHT);
	}
	setActivityHeight(aHeight);

	// setting various colors
	setBackgroundColor(properties.getProperty("BackgroundColor"));
	setHighlightColor(properties.getProperty("HighlightColor"));
	setHandleColor(properties.getProperty("HandleColor"));
	setMarqueeColor(properties.getProperty("MarqueeColor"));
	// setGridColor(properties.getProperty("GridColor"));
	// setProcessColor(properties.getProperty("ProcessColor"));
	setTransitionColor(properties.getProperty("TransitionColor"));
	setBackwardTransitionColor(properties.getProperty("BackwardTransitionColor"));
	/*
	 * setParticipantTextColor(properties.getProperty("ParticipantTextColor"));
	 * setParticipantBorderColor(properties.getProperty("ParticipantBorderColor"));
	 * setResourceSetParticipantColor(properties.getProperty("ResourceSetParticipantColor"));
	 * setResourceParticipantColor(properties.getProperty("ResourceParticipantColor"));
	 * setRoleParticipantColor(properties.getProperty("RoleParticipantColor"));
	 * setOrganizationalUnitParticipantColor(properties.getProperty("OrganizationalUnitParticipantColor"));
	 * setHumanParticipantColor(properties.getProperty("HumanParticipantColor"));
	 * setSystemParticipantColor(properties.getProperty("SystemParticipantColor"));
	 * setFreeTextExpressionParticipantColor(properties.getProperty("FreeTextExpressionParticipantColor"));
	 */
	setStartColor(properties.getProperty("StartColor"));
	setEndColor(properties.getProperty("EndColor"));
	setSelectedActivityColor(properties.getProperty("SelectedActivityColor"));
	setManualActivityColor(properties.getProperty("ManualActivityColor"));
	setAutoActivityColor(properties.getProperty("AutoActivityColor"));
	setSubFlowActivityColor(properties.getProperty("SubFlowActivityColor"));
	setBlockActivityColor(properties.getProperty("BlockActivityColor"));
	setActivityPreconditionColor(properties.getProperty("ActivityPreconditionColor"));
	setActivityPostconditionColor(properties.getProperty("ActivityPostconditionColor"));

	setGraphBackgroundColor(properties.getProperty("GraphBackgroundColor"));

	// ##################远端服务器参数配置###################
	setServerName(properties.getProperty("ServerName"));
	setServerPort(properties.getProperty("ServerPort"));
	setUserName(properties.getProperty("UserName"));
    }

    public String getStartingLocale() {
	return properties.getProperty("StartingLocale");
    }

    public void setStartingLocale(String sl) {
	if (sl != null) {
	    properties.setProperty("StartingLocale", sl);
	} else {
	    properties.setProperty("StartingLocale", DEFAULT_STARTING_LOCALE);
	}
    }

    public boolean getMandatoryConformanceClassSettingStatus() {
	if (DEFAULT_MANDATORY_CONFORMANCE_CLASS_SETTING_STATUS.equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    public void setMandatoryConformanceClassSettingStatus(boolean status) {
	if (status) {
	    properties.setProperty("MandatoryConformanceClassSettingStatus", ON_STATUS);
	} else {
	    properties.setProperty("MandatoryConformanceClassSettingStatus", OFF_STATUS);
	}
	xmlInterface.setValidation(status);
    }

    public String getMandatoryConformanceClass() {
	return DEFAULT_MANDATORY_CONFORMANCE_CLASS;
    }

    public void setMandatoryConformanceClass(String mcl) {
	if (mcl != null) {
	    properties.setProperty("MandatoryConformanceClass", mcl);
	} else {
	    properties.setProperty("MandatoryConformanceClass", DEFAULT_MANDATORY_CONFORMANCE_CLASS);
	}
    }

    public boolean getValidationStatus() {
	if (properties.getProperty("ValidationStatus").equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    public boolean getUseBubblesStatus() {
	return true;
	/*
	 * if (properties.getProperty("UseBubblesStatus").equalsIgnoreCase(ON_STATUS)) { return true; } else { return
	 * false; }
	 */
    }

    public void setUseBubblesStatus(boolean status) {
	if (status) {
	    properties.setProperty("UseBubblesStatus", ON_STATUS);
	} else {
	    properties.setProperty("UseBubblesStatus", OFF_STATUS);
	}
    }

    public void setValidationStatus(boolean status) {
	if (status) {
	    properties.setProperty("ValidationStatus", ON_STATUS);
	} else {
	    properties.setProperty("ValidationStatus", OFF_STATUS);
	}
	xmlInterface.setValidation(status);
    }

    // exit by wenzhang 如果没有值则调用com.birosoft.liquid.LiquidLookAndFeel
    public String getLookAndFeelClassName() {
	String lookAndFeelClassName = properties.getProperty("LookAndFeelClassName");
	if (lookAndFeelClassName == null || lookAndFeelClassName.equals("")) {
	    lookAndFeelClassName = "com.birosoft.liquid.LiquidLookAndFeel";
	}
	return lookAndFeelClassName;
	// return properties.getProperty("LookAndFeelClassName");
    }

    public void setLookAndFeelClassName(String lafCN) {
	if (lafCN != null) {
	    try {
		if (lafCN.length() == 0) {
		    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		    properties.setProperty("LookAndFeelClassName", DEFAULT_LOOK_AND_FEEL_CLASS_NAME);
		} else {
		    UIManager.setLookAndFeel(lafCN);
		    properties.setProperty("LookAndFeelClassName", lafCN);
		}
	    } catch (Exception ex) {
	    }
	} else {
	    properties.setProperty("LookAndFeelClassName", DEFAULT_LOOK_AND_FEEL_CLASS_NAME);
	    try {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    } catch (Exception ex) {
	    }
	}
	// try {
	// NimRODLookAndFeel nf = new NimRODLookAndFeel();
	// NimRODTheme nt = new NimRODTheme();
	// UIManager.setLookAndFeel( nf);
	// NimRODLookAndFeel.setCurrentTheme( nt);
	// }
	// catch ( Exception ex) {
	// System.out.println( ex);
	// }
    }

    public int getRecentFileListSize() {
	return Integer.valueOf(properties.getProperty("RecentFileListSize")).intValue();
    }

    public void setRecentFileListSize(int rfls) {
	if (rfls < 1) {
	    rfls = 1;
	}
	if (rfls > 16) {
	    rfls = 16;
	}
	properties.setProperty("RecentFileListSize", String.valueOf(rfls));
    }

    public boolean getTooltipStatus() {
	if (properties.getProperty("TooltipStatus").equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    public void setTooltipStatus(boolean status) {
	if (status) {
	    properties.setProperty("TooltipStatus", ON_STATUS);
	} else {
	    properties.setProperty("TooltipStatus", OFF_STATUS);
	}
	// Changes of Tooltip
	ToolTipManager.sharedInstance().setEnabled(status);
    }

    /**
     * 获得流程树型列表的展开状态
     * 
     * @return boolean
     */
    public boolean getJTreeExpandStatus() {
	if (properties.getProperty("JTreeExpandStatus").equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    /**
     * 设置流程树型列表的展开状态
     * 
     * @param status
     */
    public void setJTreeExpandStatus(boolean status) {
	if (status) {
	    properties.setProperty("JTreeExpandStatus", ON_STATUS);
	} else {
	    properties.setProperty("JTreeExpandStatus", OFF_STATUS);
	}
    }

    public boolean getGridStatus() {
	if (DEFAULT_GRID_STATUS.equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    public void setGridStatus(boolean status) {
	if (status) {
	    properties.setProperty("GridStatus", ON_STATUS);
	} else {
	    properties.setProperty("GridStatus", OFF_STATUS);
	}
    }

    public boolean getStatusBarStatus() {
	if (properties.getProperty("StatusBarStatus").equalsIgnoreCase(ON_STATUS)) {
	    return true;
	} else {
	    return false;
	}
    }

    public void setStatusBarStatus(boolean status) {
	if (status) {
	    properties.setProperty("StatusBarStatus", ON_STATUS);
	} else {
	    properties.setProperty("StatusBarStatus", OFF_STATUS);
	}
    }

    public int getLDAPCountLimit() {
	return Integer.valueOf(DEFAULT_LDAP_COUNT_LIMIT).intValue();
    }

    public void setLDAPCountLimit(int lcl) {
	if (lcl < 0) {
	    lcl = 0;
	}
	properties.setProperty("LDAPCountLimit", String.valueOf(lcl));
    }

    public int getLDAPTimeLimit() {
	return Integer.valueOf(DEFAULT_LDAP_TIME_LIMIT).intValue();
    }

    public void setLDAPTimeLimit(int ltl) {
	if (ltl < 0) {
	    ltl = 0;
	}
	properties.setProperty("LDAPTimeLimit", String.valueOf(ltl));
    }

    public int getGridSize() {
	return Integer.valueOf(DEFAULT_GRID_SIZE).intValue();
    }

    public void setGridSize(int gs) {
	if (gs < MIN_GRID_SIZE) {
	    gs = MIN_GRID_SIZE;
	}
	properties.setProperty("GridSize", String.valueOf(gs));
    }

    public String getEncoding() {
	String encoding = properties.getProperty("Encoding");
	if (encoding == null) {
	    encoding = ResourceManager.getLanguageDependentString("Sys.Encoding");
	}
	;
	return encoding;
    }

    public void setEncoding(String enc) {
	if (enc != null) {
	    properties.setProperty("Encoding", enc);
	} else {
	    properties.setProperty("Encoding", DEFAULT_ENCODING);
	}
    }

    public int getProcessWidth() {
	// return
	// Integer.valueOf(properties.getProperty("ProcessWidth")).intValue();
	return Integer.valueOf(DEFAULT_PROCESS_WIDTH).intValue();
    }

    public void setProcessWidth(int pw) {
	if (pw < MIN_PROCESS_WIDTH) {
	    pw = MIN_PROCESS_WIDTH;
	}
	properties.setProperty("ProcessWidth", String.valueOf(pw));
    }

    public int getProcessHeight() {
	// return
	// Integer.valueOf(properties.getProperty("ProcessHeight")).intValue();
	return Integer.valueOf(DEFAULT_PROCESS_HEIGHT).intValue();
    }

    public void setProcessHeight(int ph) {
	if (ph < MIN_PROCESS_HEIGHT) {
	    ph = MIN_PROCESS_HEIGHT;
	}
	properties.setProperty("ProcessHeight", String.valueOf(ph));
    }

    public int getMinParticipantWidth() {
	// return
	// Integer.valueOf(properties.getProperty("MinParticipantWidth")).intValue();
	return Integer.valueOf(DEFAULT_MIN_PARTICIPANT_WIDTH).intValue();
    }

    public void setMinParticipantWidth(int mpw) {
	if (mpw < MIN_MIN_PARTICIPANT_WIDTH) {
	    mpw = MIN_MIN_PARTICIPANT_WIDTH;
	}
	properties.setProperty("MinParticipantWidth", String.valueOf(mpw));
    }

    public int getMinParticipantHeight() {
	// return
	// Integer.valueOf(properties.getProperty("MinParticipantHeight")).intValue();
	return Integer.valueOf(DEFAULT_MIN_PARTICIPANT_HEIGHT).intValue();
    }

    public void setMinParticipantHeight(int mph) {
	if (mph < MIN_MIN_PARTICIPANT_HEIGHT) {
	    mph = MIN_MIN_PARTICIPANT_HEIGHT;
	}
	properties.setProperty("MinParticipantHeight", String.valueOf(mph));
    }

    public int getParticipantNameWidth() {
	// return
	// Integer.valueOf(properties.getProperty("ParticipantNameWidth")).intValue();
	return Integer.valueOf(DEFAULT_PARTICIPANT_NAME_WIDTH).intValue();
    }

    public void setParticipantNameWidth(int pnw) {
	if (pnw < MIN_PARTICIPANT_NAME_WIDTH) {
	    pnw = MIN_PARTICIPANT_NAME_WIDTH;
	}
	properties.setProperty("ParticipantNameWidth", String.valueOf(pnw));
    }

    public int getActivityWidth() {
	return Integer.valueOf(properties.getProperty("ActivityWidth")).intValue();
    }

    public void setActivityWidth(int aw) {
	if (aw < MIN_ACTIVITY_WIDTH) {
	    aw = MIN_ACTIVITY_WIDTH;
	}
	properties.setProperty("ActivityWidth", String.valueOf(aw));
    }

    public int getActivityHeight() {
	return Integer.valueOf(properties.getProperty("ActivityHeight")).intValue();
    }

    public void setActivityHeight(int ah) {
	if (ah < MIN_ACTIVITY_HEIGHT) {
	    ah = MIN_ACTIVITY_HEIGHT;
	}
	properties.setProperty("ActivityHeight", String.valueOf(ah));
    }

    public int getInnerActivityWidth() {
	return getActivityWidth() - 8;
    }

    public int getInnerActivityHeight() {
	return getActivityHeight() - 6;
    }

    public String getBackgroundColor() {
	return properties.getProperty("BackgroundColor");
    }

    public void setBackgroundColor(String col) {
	properties.setProperty("BackgroundColor", createColorString(col, getBackgroundColor()));
    }

    // 图形面板背景色
    public String getGraphBackgroundColor() {
	return properties.getProperty("GraphBackgroundColor");
    }

    public void setGraphBackgroundColor(String col) {
	properties.setProperty("GraphBackgroundColor", createColorString(col, getGraphBackgroundColor()));
    }

    //
    public String getHighlightColor() {
	return properties.getProperty("HighlightColor");
    }

    public void setHighlightColor(String col) {
	properties.setProperty("HighlightColor", createColorString(col, getHighlightColor()));
    }

    public String getHandleColor() {
	return properties.getProperty("HandleColor");
    }

    public void setHandleColor(String col) {
	properties.setProperty("HandleColor", createColorString(col, getHandleColor()));
    }

    public String getMarqueeColor() {
	return properties.getProperty("MarqueeColor");
    }

    public void setMarqueeColor(String col) {
	properties.setProperty("MarqueeColor", createColorString(col, getMarqueeColor()));
    }

    public String getGridColor() {
	// return properties.getProperty("GridColor");
	return DEFAULT_GRID_COLOR;
    }

    public void setGridColor(String col) {
	properties.setProperty("GridColor", createColorString(col, getGridColor()));
    }

    public String getProcessColor() {
	// return properties.getProperty("ProcessColor");
	return DEFAULT_PROCESS_COLOR;
    }

    public void setProcessColor(String col) {
	properties.setProperty("ProcessColor", createColorString(col, getProcessColor()));
    }

    public String getTransitionColor() {
	return properties.getProperty("TransitionColor");
    }

    public void setTransitionColor(String col) {
	properties.setProperty("TransitionColor", createColorString(col, getTransitionColor()));
    }

    public String getBackwardTransitionColor() {
	return properties.getProperty("BackwardTransitionColor");
    }

    public void setBackwardTransitionColor(String col) {
	properties.setProperty("BackwardTransitionColor", createColorString(col, getBackwardTransitionColor()));
    }

    public String getParticipantTextColor() {
	// return properties.getProperty("ParticipantTextColor");
	return DEFAULT_PARTICIPANT_TEXT_COLOR;
    }

    public void setParticipantTextColor(String col) {
	properties.setProperty("ParticipantTextColor", createColorString(col, getParticipantTextColor()));
    }

    public String getParticipantBorderColor() {
	// return properties.getProperty("ParticipantBorderColor");
	return DEFAULT_PARTICIPANT_BORDER_COLOR;
    }

    public void setParticipantBorderColor(String col) {
	properties.setProperty("ParticipantBorderColor", createColorString(col, getParticipantBorderColor()));
    }

    public String getResourceSetParticipantColor() {
	// return properties.getProperty("ResourceSetParticipantColor");
	return DEFAULT_RESOURCE_SET_PARTICIPANT_COLOR;
    }

    public void setResourceSetParticipantColor(String col) {
	properties.setProperty("ResourceSetParticipantColor", createColorString(col, getResourceSetParticipantColor()));
    }

    public String getResourceParticipantColor() {
	// return properties.getProperty("ResourceParticipantColor");
	return DEFAULT_RESOURCE_PARTICIPANT_COLOR;
    }

    public void setResourceParticipantColor(String col) {
	properties.setProperty("ResourceParticipantColor", createColorString(col, getResourceParticipantColor()));
    }

    public String getRoleParticipantColor() {
	// return properties.getProperty("RoleParticipantColor");
	return DEFAULT_ROLE_PARTICIPANT_COLOR;
    }

    public void setRoleParticipantColor(String col) {
	properties.setProperty("RoleParticipantColor", createColorString(col, getRoleParticipantColor()));
    }

    public String getOrganizationalUnitParticipantColor() {
	// return properties.getProperty("OrganizationalUnitParticipantColor");
	return DEFAULT_ORGANIZATIONAL_UNIT_PARTICIPANT_COLOR;
    }

    public void setOrganizationalUnitParticipantColor(String col) {
	properties.setProperty("OrganizationalUnitParticipantColor", createColorString(col, getOrganizationalUnitParticipantColor()));
    }

    public String getHumanParticipantColor() {
	// return properties.getProperty("HumanParticipantColor");
	return DEFAULT_HUMAN_PARTICIPANT_COLOR;
    }

    public void setHumanParticipantColor(String col) {
	properties.setProperty("HumanParticipantColor", createColorString(col, getHumanParticipantColor()));
    }

    public String getSystemParticipantColor() {
	// return properties.getProperty("SystemParticipantColor");
	return DEFAULT_SYSTEM_PARTICIPANT_COLOR;
    }

    public void setSystemParticipantColor(String col) {
	properties.setProperty("SystemParticipantColor", createColorString(col, getSystemParticipantColor()));
    }

    public String getFreeTextExpressionParticipantColor() {
	// return properties.getProperty("FreeTextExpressionParticipantColor");
	return DEFAULT_FREE_TEXT_EXPRESSION_PARTICIPANT_COLOR;
    }

    public void setFreeTextExpressionParticipantColor(String col) {
	properties.setProperty("FreeTextExpressionParticipantColor", createColorString(col, getFreeTextExpressionParticipantColor()));
    }

    public String getStartColor() {
	return properties.getProperty("StartColor");
    }

    public void setStartColor(String col) {
	properties.setProperty("StartColor", createColorString(col, getStartColor()));
    }

    public String getEndColor() {
	return properties.getProperty("EndColor");
    }

    public void setEndColor(String col) {
	properties.setProperty("EndColor", createColorString(col, getEndColor()));
    }

    public String getSelectedActivityColor() {
	return properties.getProperty("SelectedActivityColor");
    }

    public void setSelectedActivityColor(String col) {
	properties.setProperty("SelectedActivityColor", createColorString(col, getSelectedActivityColor()));
    }

    public String getManualActivityColor() {
	return properties.getProperty("ManualActivityColor");
    }

    public void setManualActivityColor(String col) {
	properties.setProperty("ManualActivityColor", createColorString(col, getManualActivityColor()));
    }

    public String getAutoActivityColor() {
	return properties.getProperty("AutoActivityColor");
    }

    public void setAutoActivityColor(String col) {
	properties.setProperty("AutoActivityColor", createColorString(col, getAutoActivityColor()));
    }

    public String getServiceActivityColor() {
	return properties.getProperty("ServiceActivityColor");
    }

    public void setServiceActivityColor(String col) {
	properties.setProperty("ServiceActivityColor", createColorString(col, getServiceActivityColor()));
    }

    public String getDeviceActivityColor() {
	return properties.getProperty("DeviceActivityColor");
    }

    public String getEventActivityColor() {
	return properties.getProperty("EventActivityColor");
    }

    public void getEventActivityColor(String col) {
	properties.setProperty("EventActivityColor", createColorString(col, getEventActivityColor()));
    }

    public void setDeviceActivityColor(String col) {
	properties.setProperty("DeviceActivityColor", createColorString(col, getDeviceActivityColor()));
    }

    public String getSubFlowActivityColor() {
	return properties.getProperty("SubFlowActivityColor");
    }

    public void setSubFlowActivityColor(String col) {
	properties.setProperty("SubFlowActivityColor", createColorString(col, getSubFlowActivityColor()));
    }

    public String getOutFlowActivityColor() {
	return properties.getProperty("OutFlowActivityColor");
    }

    public void setOutFlowActivityColor(String col) {
	properties.setProperty("OutFlowActivityColor", createColorString(col, getSubFlowActivityColor()));
    }

    public String getBlockActivityColor() {
	return properties.getProperty("BlockActivityColor");
    }

    public void setBlockActivityColor(String col) {
	properties.setProperty("BlockActivityColor", createColorString(col, getBlockActivityColor()));
    }

    public String getActivityPreconditionColor() {
	return properties.getProperty("ActivityPreconditionColor");
    }

    public void setActivityPreconditionColor(String col) {
	properties.setProperty("ActivityPreconditionColor", createColorString(col, getActivityPreconditionColor()));
    }

    public String getActivityPostconditionColor() {
	return properties.getProperty("ActivityPostconditionColor");
    }

    public void setActivityPostconditionColor(String col) {
	properties.setProperty("ActivityPostconditionColor", createColorString(col, getActivityPostconditionColor()));
    }

    /**
     * 获得服务器名称
     * 
     * @return String 返回服务器名称
     */
    public String getServerName() {
	return properties.getProperty("ServerName");
    }

    /**
     * 设置服务器名称值
     * 
     * @param serverName
     *            服务器名称
     */
    public void setServerName(String serverName) {
	properties.setProperty("ServerName", serverName);
    }

    /**
     * 获得服务器名称
     * 
     * @return String 返回服务器名称
     */
    public String getServerPort() {
	return properties.getProperty("ServerPort");
    }

    /**
     * 设置服务端口值
     * 
     * @param serverPort
     *            服务端口名称
     */
    public void setServerPort(String serverPort) {
	properties.setProperty("ServerPort", serverPort);
    }

    /**
     * 获得登陆用户名称
     * 
     * @return String 返回登陆用户名称
     */
    public String getUserName() {
	return properties.getProperty("UserName");
    }

    /**
     * 设置登陆用户名称值
     * 
     * @param userName
     *            登陆用户名称
     */
    public void setUserName(String userName) {
	properties.setProperty("UserName", userName);
    }

    private String createColorString(String col, String defaultColor) {
	if (col == null)
	    return defaultColor;
	Color c = Utils.getColor(col);
	if (c == null) {
	    return defaultColor;
	}
	return col;
    }

    public void restoreDefaultSettings() {
	setDefaultValues();
	initialize();
    }

    public void saveConf() {
	// check if BPD user folder exists, and if not, create it
	File ujdir = new File(BPDConstants.BPD_USER_HOME);
	if (!ujdir.exists()) {
	    try {
		ujdir.mkdir();
	    } catch (Exception exc) {
	    }
	    ;
	}
	try {
	    OutputStream out = new FileOutputStream(cfn);
	    properties.store(out, "#\n# BPD configuration\n#\n");
	    out.close();
	} catch (IOException io) {
	}
    }

    // ---------------------The below code was written by
    /**
     * 得到系统配置的字体信息
     */
    public Font getFont() {
	String fontName = ResourceManager.getLanguageDependentString("Sys.Font.name");
	String fontStyle = ResourceManager.getLanguageDependentString("Sys.Font.style");
	String fontSize = ResourceManager.getLanguageDependentString("Sys.Font.size");
	if (fontName != null && !fontName.equals("") && fontStyle != null && fontSize != null) {
	    return new Font(fontName, Integer.parseInt(fontStyle), Integer.parseInt(fontSize));
	} else {
	    return BPDConstants.DEFAULTFONT;
	}
    }

    public void setNameWrappingStatus(boolean status) {
	if (status) {
	    properties.setProperty("NameWrappingStatus", ON_STATUS);
	} else {
	    properties.setProperty("NameWrappingStatus", OFF_STATUS);
	}
    }

    public boolean getWrappingStyleWordStatus() {
	return true;
	/*
	 * if (properties.getProperty("WrappingStyleWordStatus").equalsIgnoreCase(ON_STATUS)) { return true; } else {
	 * return false; }
	 */
    }

    public boolean getNameWrappingStatus() {
	return true;

    }

    public String getDefaultExceptionTransitionColor() {
	return DEFAULT_ACTIVITY_PRECONDITION_COLOR;
    }

    public String getExceptionTransitionColor() {
	return DEFAULT_HANDLE_COLOR;
    }

    public String getOtherwiseTransitionColor() {
	return DEFAULT_ACTIVITY_PRECONDITION_COLOR;
    }

    // ---------------------The above code was written by
    // Huchm-------------------

}
