package com.ds.web.util;

import com.ds.enums.service.RequestType;
import com.ds.web.RequestMethodBean;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.InterfaceMaker;

import java.lang.reflect.*;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JSONGenUtil {

    static Map<Class, Class> classMap = new HashMap<>();

    public static Class fillSetMethod(Class iClass) {
        Class clazz = classMap.get(iClass);
        if (clazz == null) {
            if (iClass.isInterface()) {
                InterfaceMaker im = new InterfaceMaker();
                Method[] methods = iClass.getDeclaredMethods();
                im.add(iClass);
                for (Method imethod : methods) {
                    if (imethod.getName().startsWith("get") || (imethod.getName().startsWith("is") &&
                            (imethod.getGenericReturnType().equals(boolean.class)
                                    || imethod.getGenericReturnType().equals(Boolean.class)))) {
                        String setMethodName = "set" + imethod.getName().substring(3, imethod.getName().length());

                        if (imethod.getName().startsWith("is")) {
                            setMethodName = "set" + imethod.getName().substring(2, imethod.getName().length());
                        }

                        Method setMethod = null;
                        try {
                            setMethod = iClass.getMethod(setMethodName, new Class[]{imethod.getReturnType()});
                        } catch (NoSuchMethodException e) {

                        }
                        if (setMethod == null) {
                            org.objectweb.asm.Type[] argumentTypes = TypeUtils.getTypes(new Class[]{imethod.getReturnType()});
                            Signature sig = new Signature(setMethodName, org.objectweb.asm.Type.VOID_TYPE, argumentTypes);
                            im.add(sig, null);
                        }
                    }

                }
                clazz = im.create();
                classMap.put(iClass, clazz);
            } else {
                clazz = iClass;
                classMap.put(iClass, clazz);
            }
        }
        return clazz;

    }


    public static Class getListReturnType(Method method) {
        Class iClass = null;
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType) type;
            if (ptype.getActualTypeArguments()[0] instanceof ParameterizedType) {
                ParameterizedType itype = (ParameterizedType) ptype.getActualTypeArguments()[0];
                iClass = (Class) itype.getRawType();
            }
        }
        return iClass;
    }


    public static Class getInnerReturnType(Field field) {
        Type type = field.getGenericType();
        return getInnerType(type);
    }

    public static Set<Class> getAllInnerReturnType(Field field, Set<Class> classSet) {
        if (classSet == null) {
            classSet = new LinkedHashSet<>();
        }
        Type type = field.getGenericType();
        return getInnerType(type, classSet);
    }

    public static Class getInnerRequestClass(RequestMethodBean methodBean) throws ClassNotFoundException {
        Class inclazz = null;
        if (methodBean.getRequestType().equals(RequestType.JSON)) {
            inclazz = methodBean.getSourceMethod().getParameterTypes()[0];
        } else {
            inclazz = JSONGenUtil.getInnerReturnType(methodBean.getSourceMethod());
        }
        return inclazz;
    }

    public static Class getInnerReturnType(RequestMethodBean methodBean) throws ClassNotFoundException {
        Class inclazz = JSONGenUtil.getInnerReturnType(methodBean.getSourceMethod());
        return inclazz;
    }


    public static Class getInnerReturnType(Method method) {
        Type type = method.getGenericReturnType();
        return getInnerType(type);
    }

    public static Set<Class> getAllInnerReturnType(Method method, Set<Class> classSet) {
        if (classSet == null) {
            classSet = new LinkedHashSet<>();
        }
        Type type = method.getGenericReturnType();
        return getInnerType(type, classSet);
    }

    public static Class getInnerReturnType(Class clazz) {
        Type type = clazz.getTypeParameters()[0];
        return getInnerType(type);
    }

    public static Set<Class> getInnerType(Type type, Set<Class> classSet) {

        if (type instanceof Class) {
            classSet.add((Class) type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType) type;
            classSet.add((Class) ptype.getRawType());
            for (Type parameterizedType : ptype.getActualTypeArguments()) {
                if (!parameterizedType.equals(type)) {
                    classSet = getInnerType(parameterizedType, classSet);
                }
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable ptype = (TypeVariable) type;
            for (AnnotatedType typeVariable : ptype.getAnnotatedBounds()) {
                if (!typeVariable.getType().equals(type)) {
                    classSet = getInnerType(typeVariable.getType(), classSet);
                }
            }
        } else if (type instanceof WildcardType) {
            WildcardType ptype = (WildcardType) type;
            for (Type wildcardType : ptype.getUpperBounds()) {
                if (!wildcardType.equals(type)) {
                    classSet = getInnerType(wildcardType, classSet);
                }
            }
        } else {
            classSet.add(type.getClass());
        }

        return classSet;
    }


    public static Class getInnerType(Type type) {
        Class iClass = null;
        if (type instanceof Class) {
            iClass = (Class) type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType) type;
            iClass = getInnerType(ptype.getActualTypeArguments()[0]);
        } else if (type instanceof TypeVariable) {
            iClass = getInnerType(((TypeVariable) type).getAnnotatedBounds()[0].getType());
        } else if (type instanceof WildcardType) {
            iClass = getInnerType(((WildcardType) type).getUpperBounds()[0]);
        } else {
            iClass = type.getClass();
        }
        return iClass;
    }

}
