package com.ds.web.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ds.esb.config.EsbBeanAnnotation;


@EsbBeanAnnotation(id = "JSON")
public class JSONUtil {

    public String toString(Object object) {
        return JSON.toJSONString(object, true).toString();
    }

    public JSONObject parseObject(String json) {
        JSONObject jsonObject = JSON.parseObject(json);
        return jsonObject;
    }

    public JSONArray parseArray(String json) {
        JSONArray jsonObject = JSON.parseArray(json);
        return jsonObject;
    }


}
