package com.ds.web.client;


import java.util.List;
import java.util.Set;

import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.annotation.AbstractAnnotationtExpressionTempManager;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ExpressionTempBean;

import com.ds.web.util.AnnotationUtil;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringMVCTempXMLProxy extends AbstractAnnotationtExpressionTempManager {
	private static final Log logger = LogFactory.getLog(
			JDSConstants.CONFIG_KEY, SpringMVCTempXMLProxy.class);
	
	
	
	public SpringMVCTempXMLProxy(EsbBean esbBean) {
		this.esbBean=esbBean;
	}
 
	public void fillBean(Set<Class<?>> classList) {
		
		
		for (Class<?> clazz :classList) {
			RequestMapping mvcConsol =AnnotationUtil.getClassAnnotation(clazz,RequestMapping.class);
			if (mvcConsol != null) {
				ExpressionTempBean expressionTempBean = new ExpressionTempBean();
				String name =mvcConsol.value()[0]+"/";				
				String id =clazz.getSimpleName();
				expressionTempBean.setDataType(ContextType.Action);
				expressionTempBean.setExpressionArr("GetClientService(\""+clazz.getName()+"\",\""+esbBean.getServerUrl()+"\")");
				expressionTempBean.setClazz(GetClientService.class.getName());
				expressionTempBean.setId(id);
				expressionTempBean.setJspUrl(mvcConsol.value()[0]);
				expressionTempBean.setDesc(mvcConsol.value()[0]);
				expressionTempBean.setName(name);
				expressionTempBean.setServerUrl(esbBean.getServerUrl());
				expressionTempBean.setMainClass(clazz.getName());
				expressionTempBean.setReturntype(clazz.getSimpleName());
				this.nameMap.put(name, expressionTempBean);
				this.idMap.put(id, expressionTempBean);
				serviceBeanList.add(expressionTempBean);
				//System.out.println("$"+expressionTempBean.getId() + expressionTempBean.getExpressionArr());
			}

		}





	}



}