package com.ds.web.annotation;

import com.ds.enums.Enumstype;

public enum ViewGroupType implements Enumstype {
    charts("统计图表", "xui-uicmd-location"),
    svg("SVG绘图", "spafont spa-icon-editpath"),
    module("内嵌模块", "spafont spa-icon-conf"),
    dic("字典辅助", "spafont spa-icon-function"),
    domain("通用域", "spafont spa-icon-shukongjian"),
    view("视图组件", "spafont spa-icon-c-buttonviews"),
    nav("框架导航",  "xui-icon-dialog"),
    navtree("导航树", "spafont spa-icon-shukongjian");


    private final String name;
    private final String imageClass;


    ViewGroupType(String name, String imageClass) {
        this.name = name;
        this.imageClass = imageClass;
    }


    public String getImageClass() {
        return imageClass;
    }

    @Override
    public String toString() {
        return name();
    }

    @Override
    public String getType() {
        return name();
    }

    @Override
    public String getName() {
        return name;
    }
}
