package com.ds.web.annotation;

import com.ds.enums.CustomBean;
import com.ds.web.util.AnnotationUtil;

@AnnotationType(clazz = View.class)
public class ViewBean implements CustomBean {

    String viewInstId;

    String domainId;

    String imageClass;

    Class aggClass;

    Class entityClass;

    public ViewBean() {

    }

    public String getViewInstId() {
        return viewInstId;
    }

    public void setViewInstId(String viewInstId) {
        this.viewInstId = viewInstId;
    }

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getImageClass() {
        return imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public Class getAggClass() {
        return aggClass;
    }

    public void setAggClass(Class aggClass) {
        this.aggClass = aggClass;
    }

    public Class getEntityClass() {
        return entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public ViewBean(View annotation) {
        fillData(annotation);
    }

    public ViewBean fillData(View annotation) {
        return AnnotationUtil.fillBean(annotation, this);
    }

    public String toAnnotationStr() {
        return AnnotationUtil.toAnnotationStr(this);
    }

}
