package com.ds.web.annotation;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.util.ClassUtility;
import com.ds.enums.CustomBean;
import com.ds.web.util.AnnotationUtil;

@AnnotationType(clazz = Entity.class)
public class EntityBean implements CustomBean {
    Class sourceClass;

    Class serviceClass;

    Class rootClass;


    public EntityBean() {

    }

    public Class getSourceClass() {
        return sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Class getServiceClass() {
        return serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public Class getRootClass() {
        return rootClass;
    }

    public void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public EntityBean(Entity annotation) {
        fillData(annotation);
    }

    public EntityBean fillData(Entity annotation) {
        return AnnotationUtil.fillBean(annotation, this);
    }

    public String toAnnotationStr() {
        return AnnotationUtil.toAnnotationStr(this);
    }

}
