package com.ds.web.annotation;

import com.ds.enums.CustomBean;
import com.ds.web.util.AnnotationUtil;

@AnnotationType(clazz = Aggregation.class)
public class AggregationBean implements CustomBean {


    String domainId;

    AggregationType type;

    Class entityClass;

    Class sourceClass;

    Class rootClass;

    public AggregationBean() {

    }

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public AggregationType getType() {
        return type;
    }

    public void setType(AggregationType type) {
        this.type = type;
    }

    public Class getEntityClass() {
        return entityClass;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public Class getSourceClass() {
        return sourceClass;
    }

    public void setSourceClass(Class sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Class getRootClass() {
        return rootClass;
    }

    public void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public AggregationBean(Aggregation annotation) {
        fillData(annotation);
    }

    public AggregationBean fillData(Aggregation annotation) {
        return AnnotationUtil.fillBean(annotation, this);
    }

    public String toAnnotationStr() {
        return AnnotationUtil.toAnnotationStr(this);
    }

}
