package com.ds.web.annotation;

import com.ds.enums.BeanClass;

import java.lang.annotation.*;

@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
@BeanClass(clazz = AggregationBean.class)
public @interface Aggregation {

    String domainId() default "default";

    AggregationType type() default AggregationType.customapi;

    Class entityClass() default Void.class;

    Class sourceClass() default Void.class;

    Class rootClass() default Void.class;

}
