package com.ds.web;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.util.ClassUtility;
import com.ds.web.json.JSONData;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

public class RequestParamBean {
    @JSONField(serialize = false)
    Set<Annotation> annotations = new LinkedHashSet<Annotation>();

    @JSONField(serialize = false)
    private String sourceClassName;

    @JSONField(serialize = false)
    private String domainId;

    @JSONField(serialize = false)
    private String methodName;

    @JSONField(serialize = false, deserialize = false)
    Type paramType;

    String paramName;

    Boolean jsonData = false;

    String paramClassName;


    public RequestParamBean() {

    }


    public RequestParamBean clone() {
        RequestParamBean paramBean = new RequestParamBean();
        paramBean.setParamName(this.getParamName());
        paramBean.setParamClassName(this.getParamClassName());
        paramBean.setAnnotations(this.getAnnotations());
        paramBean.setDomainId(this.getDomainId());
        paramBean.setParamType(this.getParamType());
        paramBean.setJsonData(this.getJsonData());
        paramBean.setSourceClassName(this.getSourceClassName());
        paramBean.setMethodName(this.getMethodName());
        return paramBean;
    }

    public RequestParamBean copy(RequestParamBean paramBean) {
        paramBean.setParamName(this.getParamName());
        paramBean.setParamClassName(this.getParamClassName());
        paramBean.setAnnotations(this.getAnnotations());
        paramBean.setDomainId(this.getDomainId());
        paramBean.setParamType(this.getParamType());
        paramBean.setJsonData(this.getJsonData());
        paramBean.setSourceClassName(this.getSourceClassName());
        paramBean.setMethodName(this.getMethodName());
        return paramBean;
    }

    public RequestParamBean(String paramName, Set<Annotation> annotations, Type paramType, Class paramClass) {
        this.paramName = paramName;
        this.annotations = annotations;
        this.paramType = paramType;
        this.paramClassName = paramClass.getName();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().equals(JSONData.class)) {
                jsonData = true;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RequestParamBean) {
            return ((RequestParamBean) obj).getParamName().equals(paramName) && ((RequestParamBean) obj).getParamClass().equals(getParamClass());
        }
        return super.equals(obj);
    }

    public Boolean getJsonData() {
        return jsonData;
    }

    public void setJsonData(Boolean jsonData) {
        this.jsonData = jsonData;
    }

    public Set<Annotation> getAnnotations() {
        return annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getParamName() {
        return paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public Type getParamType() {
        return paramType;
    }

    public void setParamType(Type paramType) {
        this.paramType = paramType;
    }

    @JSONField(serialize = false)
    public Class getParamClass() {
        Class paramClass = null;
        if (paramClassName != null) {
            try {
                paramClass = ClassUtility.loadClass(paramClassName);
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return paramClass;
    }


    public String getSourceClassName() {
        return sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getParamClassName() {
        return paramClassName;
    }

    public void setParamClassName(String paramClassName) {
        this.paramClassName = paramClassName;
    }
}
