package com.ds.vfs;

import java.io.PrintStream;
import java.io.PrintWriter;

public class VFSFileNotFoundException extends Exception {

	private Throwable nestedThrowable = null;

	public VFSFileNotFoundException() {
		super();
	}

	public VFSFileNotFoundException(String msg) {
		super(msg);
	}

	public VFSFileNotFoundException(Throwable nestedThrowable) {
		this.nestedThrowable = nestedThrowable;
	}

	public VFSFileNotFoundException(String msg, Throwable nestedThrowable) {
		super(msg);
		this.nestedThrowable = nestedThrowable;
	}

	public void printStackTrace() {
		super.printStackTrace();
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace();
		}
	}

	public void printStackTrace(PrintStream ps) {
		super.printStackTrace(ps);
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace(ps);
		}
	}

	public void printStackTrace(PrintWriter pw) {
		super.printStackTrace(pw);
		if (nestedThrowable != null) {
			nestedThrowable.printStackTrace(pw);
		}
	}
}
