package com.ds.vfs;

import com.ds.common.cache.Cacheable;
import com.ds.common.md5.MD5InputStream;
import com.ds.enums.db.MethodChinaName;
import com.ds.web.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * vfs对外操作对象, 获取 文件实体,副本,版本,流程, 连接，视图 相关信息
 */
@Entity
public interface FileInfo extends Cacheable {

    @MethodChinaName(cname = "取得文件标识")
    @Uid
    public String getID();

    @MethodChinaName(cname = "取得文件名称")
    public String getName();

    @MethodChinaName(cname = "取得文件路径")
    public String getPath();

    @MethodChinaName(cname = "获取文件上传人")
    public String getPersonId();

    @MethodChinaName(cname = "获取文件类型")
    public Integer getFileType();

    @MethodChinaName(cname = "文件创建时间")
    public Long getCreateTime();
//
//    @MethodChinaName(cname = "取得拥有该文件权限的所有角色")
//    public List<String> getRoleIdList(RoleType type);
//
//    @MethodChinaName(cname = "取得拥有该文件权限的所有角色")
//    public List<Role> getRoleList(RoleType type);

    @MethodChinaName(cname = "取得文件所有版本信息")
    @Ref(ref = RefType.o2m,view = ViewType.grid)
    public List<FileVersion> getVersionList();

    public Set<String> getCurrentViewIds();

    @MethodChinaName(cname = "取得当前视图")
    @Ref(ref = RefType.o2m,view = ViewType.grid)
    public List<FileView> getCurrentViews();

    @MethodChinaName(cname = "获取文件链接")
    public Set<String> getLinkIds();

    @MethodChinaName(cname = "获取文件链接")
    @Ref(ref = RefType.o2m,view = ViewType.grid)
    public List<FileLink> getLinks();

    @MethodChinaName(cname = "文件描述")
    public String getDescrition();

    public String getOldFolderId();

    // 移动使用
    public void setOldFolderId(String oldFolderId);

    public String getRight();

    @Pid
    public String getFolderId();

    @MethodChinaName(cname = "取得文件所有版本信息")
    public Set<String> getVersionIds();

    @MethodChinaName(cname = "取得当前版本id")
    public String getCurrentVersonId();

    @MethodChinaName(cname = "取得当前版本文件hash")
    public String getCurrentVersonFileHash();

    @MethodChinaName(cname = "取得当前版本")
    public FileVersion getCurrentVersion();

    @MethodChinaName(cname = "取得该文件所属所有文件夹")
    @Ref(ref = RefType.m2o,view = ViewType.dic)
    public Folder getFolder();


    @MethodChinaName(cname = "取得当前版本文件文件流")
    public MD5InputStream getCurrentVersonInputStream();


}
