package com.ds.server;

import java.util.ArrayList;
import java.util.List;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.JDSSessionHandle;
import com.ds.engine.event.Listener;

public class SessionCheckTask implements Runnable {

	private static final Log logger = LogFactory.getLog(
			JDSConstants.CONFIG_KEY, SessionCheckTask.class);

	private long expireTime;

	private String systemCode;

	public SessionCheckTask(long expireTime) {
		this.expireTime = expireTime;
	}

	public SessionCheckTask(long expireTime, String systemCode) {
		this.expireTime = expireTime;
		this.systemCode = systemCode;

	}

	public void run() {
		try {
			if (JDSServer.getInstance().started()) {
				synchronized (JDSServer.THREAD_LOCK) {

					List<JDSSessionHandle> invalidSessionList = new ArrayList<JDSSessionHandle>();
					
					JDSServer.getInstance().invalidateSession(invalidSessionList);

				}
				;

			}
		} catch (JDSException bpme) {
			logger.error("Get JDSServer instance failed.", bpme);
		}

	}

}
