package com.ds.server;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.ReturnType;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.eumus.ConfigCode;

public class JDSClientServiceImpl implements JDSClientService {

    private JDSServer jdsServer;
    private JDSSessionHandle sessionHandle;
    private ConfigCode configCode;
    private ConnectionHandle connecionHandel;
    private ConnectInfo connInfo;
    private JDSContext context;

    JDSClientServiceImpl(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        this.sessionHandle = sessionHandle;
        this.configCode = configCode;
        this.jdsServer = JDSServer.getInstance();


    }

    // --------------------------------------------- 登陆注销操作

    public void connect(ConnectInfo connInfo) throws JDSException {
        this.connInfo = connInfo;
        jdsServer.connect(this);


    }

    public ConnectionHandle getConnectionHandle() {
        return connecionHandel;
    }

    public ReturnType disconnect() throws JDSException {
        if (sessionHandle != null) {
            jdsServer.disconnect(sessionHandle);
        }

        connInfo = null;
        sessionHandle = null;
        return new ReturnType(ReturnType.MAINCODE_SUCCESS);
    }

    public ConnectInfo getConnectInfo() {
        return connInfo;
    }


    @Override
    public ConfigCode getConfigCode() {
        return configCode;
    }

    public JDSSessionHandle getSessionHandle() {
        if (sessionHandle == null) {
            JDSSessionFactory factory = new JDSSessionFactory(this.getContext());
            sessionHandle = factory.getSessionHandle();

        }
        return sessionHandle;
    }

    public void setConnectionHandle(ConnectionHandle handle) {
        this.connecionHandel = handle;
    }

    public JDSContext getContext() {
        if (context == null) {
            context = JDSActionContext.getActionContext();
        }
        return context;
    }

    public void setContext(JDSContext context) {
        this.context = context;
    }

    @Override
    public String getSystemCode() {
        return JDSActionContext.getActionContext().getSystemCode();
    }

}
