package com.ds.org;

import com.ds.enums.db.MethodChinaName;
import com.ds.web.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * 人员接口类。
 * <p>
 * Title: JDSORG组织机构中间件
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * </p>
 * <p>
 * Copyright: Copyright (c) 2003-2008
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 *
 * @author wenzhangli
 * @version 2.0
 */
@Entity
@Aggregation(type = AggregationType.aggregationRoot, sourceClass = Person.class, rootClass = Person.class)
public interface Person extends java.io.Serializable, Comparable<Person> {

    /**
     * 取得人员的标识
     *
     * @return 人员的标识
     */
    @MethodChinaName(cname = "人员标识")
    @Uid
    public String getID();

    /**
     * 取得人员的标识
     *
     * @return 人员的标识
     */
    @MethodChinaName(cname = "当前状态")
    public String getStatus();

    /**
     * 取得人员的标识
     *
     * @return 人员的标识
     */
    @MethodChinaName(cname = "组织机构ID")
    @Pid
    public String getOrgId();

    /**
     * 取得人员的帐号
     *
     * @return 人员的帐号
     */
    @MethodChinaName(cname = "帐号")
    public String getAccount();

    /**
     * 取得人员的序列
     *
     * @return 人员的序列
     */
    @MethodChinaName(cname = "排序", display = false)
    public Integer getIndex();

    /**
     * 取得人员的口令
     *
     * @return 人员的口令
     */
    @MethodChinaName(cname = "密码", display = false)
    public String getPassword();

    /**
     * 取得人员的名字
     *
     * @return 人员的名字
     */
    @MethodChinaName(cname = " 姓名")
    @Caption
    public String getName();

    /**
     * 取得人员的移动电话号码
     *
     * @return 移动电话号码
     */
    @MethodChinaName(cname = "手机号码")
    public String getMobile();

    /**
     * 昵称
     *
     * @return 昵称
     */
    @MethodChinaName(cname = "昵称")
    public String getNickName();

    /**
     * 取得人员的Email地址
     *
     * @return Email地址
     */
    @MethodChinaName(cname = "电子邮件")
    public String getEmail();

    @MethodChinaName(cname = "所有部门")
    @Ref(ref = RefType.ref, view = ViewType.grid)
    public List<Org> getOrgList();

    @Ref(ref = RefType.m2o, view = ViewType.dic)
    public Org getOrg();

    public String getCloudDiskPath();

    public Set<String> getRoleIdList();

    public Set<String> getOrgIdList();


    @Ref(ref = RefType.m2m, view = ViewType.grid)
    public List<Role> getRoleList();

}