package com.ds.msg;

import java.util.List;

import com.ds.enums.db.MethodChinaName;
import com.ds.org.Person;

/**
 * 人员个人好友组接口类。
 * <p>
 * Title: JDSORG组织机构中间件
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * </p>
 * <p>
 * Copyright: Copyright (c) 2003-2008
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public interface PersonPrivateGroup {

    public static final String OFFICE = "OFFICE", PRIVATE = "PRIVATE", SYSTEM = "SYSTEM";

    /**
     * 取得在该个人组中的所有人员。
     * 
     * @return 人员数组
     */

    @MethodChinaName(cname = "取得在该个人组中的所有人员")
    public List<Person> getPersonList();

    @MethodChinaName(cname = "取得在该个人组中的所有人员的标识", display = false)
    public List<String> getPersonIdList();

    /**
     * 取得人员个人组的名称
     * 
     * @return 人员个人组的名称
     */
    @MethodChinaName(cname = "取得人员个人组的名称")
    public String getName();

    @MethodChinaName(cname = "取得人员个人组的类别")
    public String getType();

    /**
     * 取得人员个人组的标识
     * 
     * @return 人员个人组的标识
     */
    @MethodChinaName(cname = "取得人员个人组的标识")
    public String getID();

    @MethodChinaName(cname = "取得人员ID")
    public String getPersonId();
}
