
package com.ds.esb.util.filter;

import com.ds.esb.config.manager.ExpressionTempBean;



/**
 * <p>
 * Title: JDSESB
 * </p>
 * <p>
 * Description: 总线对象过滤器
 * </p>
 * 此类为抽象类，在查询活动定义时使用的过滤器必须继承此类，否则将被忽略。
 * <p>
 * Copyright: Copyright (c) 2006
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhang li
 * @version 1.0
 */
public abstract  class ESBBeanDefFilter extends AbstractFilter {

	public boolean filterObject(Object obj) {
		if (obj instanceof ExpressionTempBean) {
			return filterESBBeanDef((ExpressionTempBean) obj);
		} else {
			return true;
		}
	}

	/**
	 * 抽象方法，继承类必须实现此方法来过滤活动定义！
	 * 
	 * @see com.ds.bpm.engine.query.Filter#filterObject(Object)
	 */
	public abstract boolean filterESBBeanDef(ExpressionTempBean obj);

}
