/**
 * $RCSfile: EIFunctionListener.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:26:06 $
 *
 * Copyright (C) 2003 itjds, Inc. All rights reserved.
 *
 * This software is the proprietary information of itjds, Inc.
 * Use is subject to license terms.
 */
package com.ds.esb.event;

import com.ds.common.JDSException;
import com.ds.engine.event.JDSListener;

/**
 * <p>
 * Title: JDS系统管理系统
 * </p>
 * <p>
 * Description: 核心活动事件监听器
 * </p>
 * <p>
 * Copyright: Copyright (c) 2008
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public interface EIFunctionListener extends JDSListener {

	/**
	 * 活动初始化完毕，进入inactive状态
	 */
	public void activityInited(EIFunctionEvent event) throws JDSException;

	/**
	 * 活动开始执行路由操作
	 */
	public void activityRouting(EIFunctionEvent event) throws JDSException;

	
}
