package com.ds.esb.config.manager;
/**
 * time 06-01-01
 *
 * @author wenzhang
 */

import com.ds.esb.config.JDSBusException;

import java.util.List;
import java.util.Map;
import java.util.Set;


public interface ServiceConfigManager {
    /**
     * 指定应用指定ID查找
     * @param id
     * @return
     */
    public ServiceBean getServiceConfigById(String id);

    /**
     * 根据模板名称查询模板实例
     * @param name
     * @return
     */
    public ServiceBean getServiceConfigByName(String name);

    /**
     * 取得所有模板列表
     * @return
     */
    public Map<String, ServiceBean> findServiceConfigMapByName();

    public Map<String, ServiceBean> findServiceConfigMapById();

    public List<ServiceBean> loadAllService();

    public Set<Class<?>> init() throws JDSBusException;

}