package com.ds.esb.config.formula;

import com.ds.enums.IconEnumstype;
import com.ds.enums.attribute.Attributetype;
import com.ds.org.RoleOtherType;
import com.ds.org.RoleType;


public enum FormulaParams implements IconEnumstype {

    PERSON(RoleOtherType.Person.getImageClass(), "人员ID", Attributetype.RIGHT),
    ORG(RoleOtherType.Org.getImageClass(), "组织ID", Attributetype.RIGHT),
    ORGROLE(RoleType.OrgRole.getImageClass(), "部门角色", Attributetype.RIGHT),
    ORGLEVEL(RoleType.OrgLevel.getImageClass(), "部门級別", Attributetype.RIGHT),
    PERSONPOSTTION(RoleType.Position.getImageClass(), "人员岗位", Attributetype.RIGHT),
    PERSONROLE(RoleType.Role.getImageClass(), " 人员角色名", Attributetype.RIGHT),
    PERSONGROUP(RoleType.Group.getImageClass(), "工作组名", Attributetype.RIGHT),
    PERSONDUTY(RoleType.Duty.getImageClass(), "人员职务名", Attributetype.RIGHT),

    PERSONLEVEL(RoleType.PersonLevel.getImageClass(), "人员职级名", Attributetype.RIGHT),
    COMTYPE(FormulaType.ESDCOM.getImageClass(), "组件类型", Attributetype.PAGE),
    CURRFORMCOM("spafont spa-icon-astext", "当前表单组件", Attributetype.PAGE),
    CURRUICOM("spafont spa-icon-c-foldingtabs", "当前UI组件", Attributetype.PAGE),
    CURRITEM("spafont spa-icon-c-treebar", "ITEM子项", Attributetype.PAGE),
    CURRBAR("spafont spa-icon-c-buttonviews", "控制按钮", Attributetype.PAGE),
    CURRTAB("spafont spa-icon-c-tabs", "TAB页", Attributetype.PAGE),
    CURRACTION("spafont spa-icon-c-imagebutton", "动作控制", Attributetype.PAGE),

    STYLE("spafont spa-icon-c-cssbox", "样式", Attributetype.PAGE),
    API("spafont spa-icon-c-webapi", "API", Attributetype.TASK),
    ESDCOM("spafont spa-icon-module", "通用组件", Attributetype.PAGE),
    ESDFORMCOM("spafont spa-icon-c-hiddeninput", "表单组件", Attributetype.PAGE),
    ESDUICOM("spafont spa-icon-frame", "UI组件", Attributetype.PAGE),
    PACKAGE("spafont spa-icon-c-iconslist", "包结构", Attributetype.PAGE),

    FOLDER("spafont spa-icon-explore", "VFS文件夾", Attributetype.PAGE),
    FILE("spafont spa-icon-project", "VFS文件", Attributetype.PAGE),

    TOPIC("spafont spa-icon-mqtt", "MQTT主题", Attributetype.SERVICE),
    MSG("xui-uicmd-info", "消息", Attributetype.SERVICE),
    CLASSNAME("spafont spa-icon-page", "页面名称", Attributetype.PAGE),
    ANIMATION("xui-uicmd-location", "动画", Attributetype.PAGE),
    TABLE("spafont spa-icon-c-grid", "数据库表", Attributetype.DB),
    FIELD("spafont spa-icon-c-counter", "字段", Attributetype.DB),
    DEVICETYPE("DEVICETYPE", "设备类型", Attributetype.DEVICE),
    GATEWAY("GATEWAY", "网关", Attributetype.DEVICE),
    AREA("AREA", "特定区域", Attributetype.CUSTOMIZE),
    PLACE("PLACE", "位置", Attributetype.CUSTOMIZE),

    DEVICEEVENT(Attributetype.DEVICEEVENT.getImageClass(), "设备事件", Attributetype.DEVICEEVENT),
    DEVICEDATAEVENT(Attributetype.DEVICEEVENT.getImageClass(), "数据上报", Attributetype.DEVICEEVENT),
    CUSTOMFORMULA(Attributetype.ADVANCE.getImageClass(), "自定义公式", Attributetype.ADVANCE),
    SENSOR(Attributetype.DEVICE.getImageClass(), "传感器", Attributetype.DEVICE),
    DeviceDataTypeKey(Attributetype.DEVICEEVENT.getImageClass(), "数据上报KEY", Attributetype.DEVICEEVENT),
    IRValue(Attributetype.COMMAND.getImageClass(), "空调控制", Attributetype.COMMAND),
    COMMAND(Attributetype.COMMAND.getImageClass(), "设备命令", Attributetype.COMMAND),
    COMMANDEVENT(Attributetype.COMMAND.getImageClass(), "命令执行结果", Attributetype.COMMAND),
    UNKNOW(Attributetype.CUSTOMIZE.getImageClass(), "未知类型", Attributetype.CUSTOMIZE),
    ZONESTATUS(Attributetype.DEVICEEVENT.getImageClass(), "报警值", Attributetype.DEVICEEVENT);

    private final Attributetype attributetype;
    private String type;

    private String name;

    private String imageClass;


    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    FormulaParams(String imageClass, String name, Attributetype attributetype) {
        this.type = name();
        this.name = name;
        this.attributetype=attributetype;

        this.imageClass = imageClass;
    }

    public Attributetype getAttributetype() {
        return attributetype;
    }

    @Override
    public String getImageClass() {
        return imageClass;
    }

    @Override
    public String toString() {
        return type;
    }

    public static FormulaParams fromType(String typeName) {
        if (typeName == null) {
            return UNKNOW;
        }
        for (FormulaParams type : FormulaParams.values()) {
            if (type.getType().equals(typeName)) {
                return type;
            }
        }
        return UNKNOW;
    }


}
