package com.ds.esb.config.formula;

import com.ds.enums.IconEnumstype;

public enum EngineType implements IconEnumstype {

    CUSTOM("bpmfont bpmgongzuoliuxitongpeizhi", "通用操作"),

    ESD("xui-icon-upload", "嵌入式引擎"),

    IOT("bpmfont bpmgongzuoliuzhutiguizeweihuguanli", "IOT引擎"),

    ESB("spafont spa-icon-app", "服务调度引擎");

    private String type;

    private String name;

    private String imageClass;

    public String getType() {
        return type;
    }


    public String getName() {
        return name;
    }

    @Override
    public String getImageClass() {
        return imageClass;
    }

    EngineType(String imageClass, String name) {
        this.imageClass = imageClass;
        this.type = name();
        this.name = name;

    }

    @Override
    public String toString() {
        return type;
    }

    public static EngineType fromType(String typeName) {
        for (EngineType type : EngineType.values()) {
            if (type.getType().equals(typeName)) {
                return type;
            }
        }
        return CUSTOM;
    }

}
