package com.ds.enums.db;

import com.ds.enums.BeanClass;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author wenzhangli
 * @since 2008-1-1
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
@BeanClass(clazz = DBFieldBean.class)
public @interface DBField {
    String dbFieldName();

    ColType dbType() default ColType.VARCHAR;

    String cnName() default "";

    String[] enums() default {};

    Class enumClass() default Void.class;

    boolean isNull() default true;

    int length() default 64;
}
