/**
 * $RCSfile: EIServerListener.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:26:02 $
 *
 * Copyright (C) 2003 itjds, Inc. All rights reserved.
 *
 * This software is the proprietary information of itjds, Inc.
 * Use is subject to license terms.
 */
package com.ds.engine.event;

import com.ds.common.JDSException;

/**
 * <p>
 * Title: JDS管理系统
 * </p>
 * <p>
 * Description: 核心服务器事件监听器接口
 * </p>
 * <p>
 * Copyright: Copyright (c) 2014
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhang li
 * @version 3.0
 */
public interface EIServerListener extends JDSListener {

	/**
	 * 服务器正在启动
	 */
	public void serverStarting(EIServerEvent event) throws JDSException;

	/**
	 * 服务器已启动
	 */
	public void serverStarted(EIServerEvent event) throws JDSException;

	/**
	 * 服务器正在停止
	 */
	public void serverStopping(EIServerEvent event) throws JDSException, InterruptedException;

	/**
	 * 服务器已停止
	 */
	public void serverStopped(EIServerEvent event) throws JDSException;
	

	
	/**
	 * 正在保存子系统
	 */
	public void systemSaving(EIServerEvent event) throws JDSException;
	
	/**
	 * 保存子系统完毕
	 */
	public void systemSaved(EIServerEvent event) throws JDSException;
	
	/**
	 * 正在删除子系统
	 */
	public void systemDeleting(EIServerEvent event) throws JDSException;
	
	
	/**
	 * 子系统删除完毕
	 */
	public void systemDeleted(EIServerEvent event) throws JDSException;

	/**
	 * 正在激活子系统
	 */
	public void systemActivating(EIServerEvent event) throws JDSException;
	

	/**
	 * 子系统激活完毕
	 */
	public void systemActivated(EIServerEvent event) throws JDSException;
	
	/**
	 * 正在冻结子系统
	 */
	public void systemFreezing(EIServerEvent event) throws JDSException;
	
	/**
	 * 冻结子系统完成
	 */
	public void systemFreezed(EIServerEvent event) throws JDSException;
	
	

}
