/**
 * $RCSfile: EIServerEvent.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:26:02 $
 *
 * Copyright (C) 2003 itjds, Inc. All rights reserved.
 *
 * This software is the proprietary information of itjds, Inc.
 * Use is subject to license terms.
 */
package com.ds.engine.event;

import com.ds.enums.ServerEventEnums;

/**
 * <p>
 * Title: JDS系统管理系统
 * </p>
 * <p>
 * Description: 核心服务器事件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2008
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public class EIServerEvent extends JDSEvent {

    public EIServerEvent(Object obj, ServerEventEnums eventID) {
	super(obj, null);
	id = eventID;

    }

    @Override
    public ServerEventEnums getID() {
	return (ServerEventEnums) id;
    }

    public EIServerEvent(ServerEventEnums eventID) {
	super("ServerEvent", null);
	id = eventID;
    }

}
