package com.ds.common.util.java;

import com.ds.common.util.ClassUtility;
import com.ds.common.util.IOUtility;

import java.io.File;
import java.io.IOException;

public class DynamicClassLoader extends ClassLoader {
    private byte[] bytes;
    private String className;

    public DynamicClassLoader(TmpJavaFileObject myJavaFileObject, String className) {
        this.bytes = myJavaFileObject.getCompiledBytes();
        this.className = className;
    }


    public void dumpFile(File file) throws IOException {
        IOUtility.writeBytesToNewFile(bytes, file);
    }


    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        try {
            // clazz = Class.forName(name);
            //this.className = name;
            clazz = super.loadClass(name);
        } catch (Throwable e) {
            clazz = ClassUtility.loadClass(name);
        }
        return clazz;
    }

    @Override
    public Package[] getPackages() {
        return super.getPackages();
    }


    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {

        Class clazz = null;
        // if (className == null || !name.equals(className)) {
        try {
            clazz = super.findClass(name);
        } catch (ClassNotFoundException e) {
        }

        if (clazz == null) {
            try {
                clazz = Class.forName(name);
            } catch (ClassNotFoundException e) {
            }
        }

        try {
            if (clazz == null) {
                clazz = defineClass(name, bytes, 0, bytes.length);
                if (clazz.getPackage() == null) {
                    String packageName = name.substring(0, name.lastIndexOf("."));
                    definePackage(packageName, "ESDDynPackage", "1.0.0", "ESD", null, null, null, null);
                }
            }

        } catch (Throwable e) {
            clazz = ClassUtility.loadClass(name);
            //throw new ClassNotFoundException();
        }
//        } else {
//            clazz = ClassUtility.loadClass(name);
//        }


        return clazz;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setTmpJavaFileObject(TmpJavaFileObject myJavaFileObject) {
        super.clearAssertionStatus();
        this.bytes = myJavaFileObject.getCompiledBytes();
    }
}

