package com.ds.common.util;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

public class ImgUtil {
   
    /**
     * @param srcImageFile    源图像文件图像地址
     * @param resultImageFile 缩放后的图像地址
     */
    public static void scaleByWidth(String srcImageFile, String resultImageFile, int cWidth) {
        try {
            // 读去图片
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int width = src.getWidth();
            int scale = width / cWidth;
            scale(srcImageFile, resultImageFile, scale, true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @param srcImageFile    源图像文件图像地址
     * @param resultImageFile 缩放后的图像地址
     */
    public static void scaleByHeight(String srcImageFile, String resultImageFile, int cHeight) {
        try {
            // 读去图片
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int height = src.getHeight();
            int scale = height / cHeight;
            scale(srcImageFile, resultImageFile, scale, true);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scale(String srcImageFile, String resultImageFile,
                             int scale, boolean flag) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            scale(src, resultImageFile, scale, flag);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * @param src             源图像文件图像地址
     * @param resultImageFile 缩放后的图像地址
     * @param scale           缩放比例
     * @param flag            缩放选择:true 放大; false 缩小;
     */
    static void scale(BufferedImage src, String resultImageFile,
                      int scale, boolean flag) throws IOException {


        // 图片宽度
        int width = src.getWidth();
        // 图片高度
        int height = src.getHeight();
        if (flag) {
            width = width * scale;
            height = height * scale;
        } else {
            // 缩小
            width = width / scale;
            height = height / scale;
        }
        Image image = src.getScaledInstance(width, height, Image.SCALE_DEFAULT);
        BufferedImage tag = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics g = tag.getGraphics();
        // 绘制处理后的图片
        g.drawImage(image, 0, 0, null);
        g.dispose();
        // 输出到文件
        ImageIO.write(tag, "png", new File(resultImageFile));

    }

}