/**
 * $RCSfile: Order.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:26:08 $
 *
 * Copyright (C) 2003 itjds, Inc. All rights reserved.
 *
 * This software is the proprietary information of itjds, Inc.
 * Use is subject to license terms.
 */
package com.ds.common.query;

import java.io.Serializable;

/**
 * <p>
 * Title: JDS系统管理系统
 * </p>
 * <p>
 * Description: 用于排序。
 * </p>
 * <p>
 * Copyright: Copyright (c) 2006
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @see Condition
 * @author wenzhang li
 * @version 1.0
 */
public class Order<T extends ConditionKey> implements Serializable {
	public T key;

	public boolean asc;

	public boolean isAsc() {
		return asc;
	}

	public void setAsc(boolean asc) {
		this.asc = asc;
	}

	/**
	 * 构造方法，确定排序字段以及排序方法

	 * 
	 * @param key
	 *            排序的字段
	 * @param asc
	 *            排序方法
	 *            <li> true - 升序（ASC）
	 *            <li> false - 降序（DESC）
	 */
	public Order(T key, boolean asc) {
		this.key = key;
		this.asc = asc;
	}

	/**
	 * 得到Order By子句
	 */
	public String toString() {
		return key.getValue()+ (asc ? " ASC" : " DESC");
	}

	public T getKey() {
		return key;
	}

	public void setKey(T key) {
		this.key = key;
	}
}
