package com.ds.common.cache.redis;

import com.ds.common.cache.Cache;

import java.io.*;
import java.util.Set;

public class Test {

    public static void main(final String[] args) {
	final RedisCacheManager manager = new RedisCacheManager("org");
	final Cache cache = manager.getCache("org");
	for (int i = 0; i < 10; i++) {
	    final Person p = new Person();
	    p.setAge(i);
	    cache.put(String.valueOf(i), p);
	}
	

	try {
	    throw new Exception();
	} catch (Exception e) {
	    e.printStackTrace();

	}

	final Set<String> set = cache.keySet();
	if (!set.isEmpty()) {
	    for (final String s : set) {
		System.out.println("是否存在key：" + s + " :" + cache.containsKey(s));
		final Person p = (Person) cache.get(s);
		System.out.println(p.getAge());
	    }

	}


    }

    // 序列化
    public static byte[] serialize(final Object obj) {
	ObjectOutputStream oos = null;
	ByteArrayOutputStream bos = null;
	try {
	    bos = new ByteArrayOutputStream();
	    oos = new ObjectOutputStream(bos);
	    oos.writeObject(obj);
	    final byte[] byt = bos.toByteArray();
	    return byt;
	} catch (final IOException e) {
	    e.printStackTrace();
	}
	return null;
    }

    // 反序列化
    public static Object unserizlize(final byte[] byt) {
	ObjectInputStream oii = null;
	ByteArrayInputStream bis = null;
	bis = new ByteArrayInputStream(byt);
	try {
	    oii = new ObjectInputStream(bis);
	    final Object obj = oii.readObject();
	    return obj;
	} catch (final Exception e) {

	    e.printStackTrace();
	}

	return null;
    }

    static class Person implements Serializable {
	private static final long serialVersionUID = 4620709995536974818L;

	Person() {

	}

	private int age;

	public int getAge() {
	    return age;
	}

	public void setAge(final int age) {
	    this.age = age;
	}
    }

}
