/**
 * $RCSfile: CacheManager.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/07/08 00:25:49 $
 *
 * Copyright (C) 2003 spk, Inc. All rights reserved.
 *
 * This software is the proprietary information of spk, Inc.
 * Use is subject to license terms.
 */
package com.ds.common.cache;

import java.util.Map;

/**
 * <p>
 * Title: 常用代码打包
 * </p>
 * <p>
 * Description: Central cache management of all caches used by diferent application. Cache sizes are stored as the
 * following common property values:
 * <ul>
 *
 * <li><tt>[appConfigKey].cache.[cacheKey].size</tt> -- cache size with cache key [cacheKey] of application with app
 * config key [appConfigKey].
 * </ul>
 *
 * All values should be in bytes. Cache can also be enabled or disabled. This value is stored as the
 * <tt>[appConfigKey].cache.enabled</tt> common property.
 * </p>
 * <p>
 * Copyright: Copyright (c) 2006
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 * 
 * @author wenzhang li
 * @version 1.0
 */
public interface CacheManager {

    public <T> Cache<String, T> createCache(String name, int maxCacheSize, long maxLifetime);

    /**
     * 
     * Gets Cache object for certain application with cacheKey
     */
    public <T> Cache<String, T> getCache(String cacheKey);

    /**
     * Returns all caches that this this manager contained.
     * 
     * @return all caches map, key - cache name, value - cache object
     */
    public <T> Map<String, T> getAllCache();


    

    /**
     * Returns true if cache is globally enabled. Cache should only be disabled for testing purposes, since it has a
     * huge impact on performance.
     *
     * @return true if cache is globally enabled.
     */
    public boolean isCacheEnabled();

}