package com.ds.cluster.udp;

import com.alibaba.fastjson.JSONObject;
import com.ds.config.UserBean;
import com.ds.enums.MsgStatus;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.JDSServer;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;

import java.util.concurrent.Callable;

public class ClusterExeEventControl implements Runnable {

    private final ClusterEvent event;

    ClusterExeEventControl(ClusterEvent event) {
        this.event = event;
    }

    @Override
    public void run() {
        ActionContext.getContext().getContextMap().put("event", event);
        if (event != null) {
            String msgId = event.getMsgId();
            String token = event.getToken();
            RuntimeLog log = ConnectionLogFactory.getInstance().createLog(token, "udp://" + JDSServer.getClusterClient().getUDPClient().getUser().getUdpIP() + ":[" + event.getSystemCode() + "]", event.getEventName() + "[" + event.getEventId() + "]", msgId);
            log.setStartTime(event.getSendTime());
            log.setBodyJson(event.getSourceJson());
            log.setArrivedTime(System.currentTimeMillis());
            log.setTime(log.getArrivedTime() - log.getStartTime());
            log.setStatus(MsgStatus.UPDATE);
            Object obj = EsbUtil.parExpression(event.getExpression());
            log.setEndTime(System.currentTimeMillis());
            if (obj != null && Boolean.valueOf(obj.toString())) {
                log.setStatus(MsgStatus.READED);
                log.setExetime(log.getEndTime() - log.getArrivedTime());
                UDPClient.getInstance().updateEventStatus(event.getToken(), MsgStatus.UPDATE);
            } else {
                log.setStatus(MsgStatus.ERROR);
                log.setExetime(log.getEndTime() - log.getArrivedTime());
                UDPClient.getInstance().updateEventStatus(event.getToken(), MsgStatus.ERROR);
            }


        }


    }
}
