package com.ds.cluster.udp;

import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.config.CApplication;
import com.ds.org.Person;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;

import java.util.List;
import java.util.Map;

public interface ClusterClient {

    void login();

    void stop();

    void start();

    UDPClient getUDPClient();

    void login(Boolean init);

    boolean isLogin();

    boolean send(String msgStr);

    void updateTaskStatus(String id, String readed);

    void reboot();

    public void reLoadConfig();

    List<ServerNode> getAllServer();

    ServerNode getServerNodeById(String nodeId);

    ServerNodeList getServerNodeListByConfigCode(ConfigCode configCode);

    Map<String, ServerNode> getAllServerMap();

    CApplication getApplication(ConfigCode systemCode);

    List<CApplication> getApplications();

    Map<ConfigCode, CApplication> getApplicationMap();

    SubSystem getSystem(String systemCode);

    List<SubSystem> getAllSystem();

    public SystemStatus getSystemStatus(String systemCode);

    public Person getAdminPerson(String systemCode);

}
