package com.ds.cluster.event;

import com.ds.engine.event.JDSEvent;
import com.ds.enums.ServerEventEnums;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;

/**
 * <p>
 * Title: VFS管理系统
 * </p>
 * <p>
 * Description: 核心文件事件
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Company: www.justdos.net
 * </p>
 *
 * @author wenzhangli
 * @version 2.0
 */
@SuppressWarnings("all")
public class ServerEvent<T extends SubSystem> extends JDSEvent<T> {


    @Override
    public T getSource() {
        return super.getSource();
    }

    /**
     * ServerEvent
     *
     * @param path
     * @param eventID
     */
    public ServerEvent(T server, ServerEventEnums eventID, String sysCode) {
        super(server, null);
        id = eventID;
        this.systemCode = sysCode;
    }

    @Override
    public ServerEventEnums getID() {
        return (ServerEventEnums) id;
    }


}
