package com.ds.cluster;


import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.SubSystem;
import net.sf.cglib.beans.BeanMap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerBeanManager {
    private static final Log logger = LogFactory.getLog(
            JDSConstants.CONFIG_KEY, ServerBeanManager.class);

    private static final String configId = "configid";

    public static Map<String, ServerNodeList> esbBeanListBeanmap = new HashMap<String, ServerNodeList>();

    public static ServerNodeList getEsbBeanList(String configName, SubSystem subSystem) {
        ServerNodeList esbBeanListBean = esbBeanListBeanmap.get(configName);
        if (esbBeanListBean == null || esbBeanListBean.getReload().equals("true")) {
            esbBeanListBean = newEsbBeanList(configName, subSystem);
            esbBeanListBeanmap.put(configName, esbBeanListBean);
        }
        return esbBeanListBean;
    }


    private static ServerNodeList newEsbBeanList(String configName, SubSystem subSystem) {
        ServerServiceConfig config = new ServerServiceConfig(configName);
        ServerNodeList esbbeanlist = new ServerNodeList();
        BeanMap esbbeanListMap = BeanMap.create(esbbeanlist);
        Iterator it = esbbeanListMap.keySet().iterator();
        for (; it.hasNext(); ) {
            String key = (String) it.next();
            Class clazz = esbbeanListMap.getPropertyType(key);
            if (clazz.isAssignableFrom(String.class)) {
                esbbeanListMap.put(key, config.getValue(key));
            } else {
                Map<String, ServerNode> esbBeanMap = new LinkedHashMap<String, ServerNode>();
                String[] esbbeanIds = config.getValues(configId);
                for (int i = 0; esbbeanIds.length > i; i++) {
                    ServerNode eabBean = new ServerNode(subSystem);
                    BeanMap beanmap = BeanMap.create(eabBean);
                    Iterator esbit = beanmap.keySet().iterator();
                    for (; esbit.hasNext(); ) {
                        String esbkey = (String) esbit.next();
                        String value = config.getValue(esbbeanIds[i] + "." + esbkey);

                        if (value != null) {
                            beanmap.put(esbkey, TypeUtils.cast(value, beanmap.getPropertyType(esbkey), null));
                        }
                    }
                    esbBeanMap.put(esbbeanIds[i], eabBean);
                    // logger.info("Server["+eabBean.getName()+"] all PersonSize="+eabBean.par().size());

                }
                esbbeanListMap.put(key, esbBeanMap);
            }
        }
        return esbbeanlist;

    }
}
