package com.ds.cluster;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSException;
import com.ds.common.util.ClassUtility;
import com.ds.config.UserBean;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;


public class ClusterMananerFactory {



    private final static String defaultManagerClassName = "com.ds.web.client.WebClusterManagerImpl";

    public static ClusterMananer getClusterManager(ConfigCode code) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClusterMananer manager = null;
        String className  = JDSServer.getClusterClient().getServerNodeListByConfigCode(code).getClusterManagerClass();

        if (className != null && !className.equals("")) {
            manager = (ClusterMananer) ClassUtility.loadClass(className).newInstance();
        } else {
            manager = (ClusterMananer) ClassUtility.loadClass(defaultManagerClassName).newInstance();
        }
        return manager;
    }



}
