/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.util;

import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.context.JDSActionContext;
import com.ds.web.BaseParamsEnums;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class PageUtil {
    public static <T, K> ListResultModel<List<T>> getPageList(Set<K> objs, Integer pageIndex, Integer pageSize, Class<T> clazz) {
        ArrayList<K> result = new ArrayList<K>();
        result.addAll(objs);
        return PageUtil.getPageList(result, pageIndex, pageSize, clazz);
    }

    public static <T, K> ListResultModel<List<T>> getPageList(List<K> objs, Integer pageIndex, Integer pageSize, Class<T> clazz) {
        ListResultModel userStatusInfo = new ListResultModel();
        ArrayList<K> pageResult = new ArrayList<K>();
        Integer objSize = objs.size();
        Object size = JDSActionContext.getActionContext().getParams(BaseParamsEnums.JDS_SIZE.name());
        if (size != null) {
            objSize = Integer.valueOf(size.toString());
            pageIndex = 1;
        }
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        int start = (pageIndex - 1) * pageSize;
        int end = pageSize * pageIndex;
        if (end > objs.size()) {
            end = objs.size();
        }
        for (int k = start; k < end; ++k) {
            Constructor<?>[] constructors;
            K obj = objs.get(k);
            if (obj == null) continue;
            if (clazz == null || obj.getClass().isAssignableFrom(clazz)) {
                pageResult.add(obj);
                continue;
            }
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                Class<?>[] paramClass = constructor.getParameterTypes();
                if (paramClass.length != 1 || !paramClass[0].isAssignableFrom(obj.getClass())) continue;
                Object t = null;
                try {
                    t = constructor.newInstance(obj);
                    pageResult.add(t);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        userStatusInfo.setSize(objSize);
        userStatusInfo.setData(pageResult);
        return userStatusInfo;
    }

    static <T> List<T> fillObj(List objs, Class<T> clazz) {
        ArrayList result = new ArrayList();
        if (objs != null) {
            for (Object obj : objs) {
                Constructor<?>[] constructors;
                if (obj == null) continue;
                if (clazz == null || obj.getClass().isAssignableFrom(clazz)) {
                    result.add(obj);
                    continue;
                }
                for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                    Class<?>[] paramClass = constructor.getParameterTypes();
                    if (paramClass.length != 1 || !paramClass[0].isAssignableFrom(obj.getClass())) continue;
                    Object t = null;
                    try {
                        t = constructor.newInstance(obj);
                        result.add(t);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static String appUrlParams(String url, String[] paramNames) {
        Object npageIndex = JDSActionContext.getActionContext().getParams(BaseParamsEnums.pageIndex.name());
        Object npageSize = JDSActionContext.getActionContext().getParams(BaseParamsEnums.pageSize.name());
        if (npageIndex != null && !Arrays.asList(paramNames).contains(BaseParamsEnums.pageIndex.name()) && url.indexOf(BaseParamsEnums.pageIndex.name()) == -1) {
            url = url + "&" + BaseParamsEnums.pageIndex.name() + "=" + npageIndex;
        }
        if (npageSize != null && !Arrays.asList(paramNames).contains(BaseParamsEnums.pageSize.name()) && url.indexOf(BaseParamsEnums.pageSize.name()) == -1) {
            url = url + "&" + BaseParamsEnums.pageSize.name() + "=" + npageSize;
        }
        return url;
    }

    public static <T, K> ListResultModel<List<T>> changPageList(ListResultModel<List<K>> objs, Class<T> clazz) {
        ListResultModel<List<List<T>>> userStatusInfo = new ListResultModel<List<List<T>>>();
        try {
            ArrayList pageResult = new ArrayList();
            List list = (List)objs.get();
            userStatusInfo.setData(PageUtil.fillObj(list, clazz));
            userStatusInfo.setSize(objs.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }

    public static <T> ListResultModel<List<T>> getDefaultPageList(List<T> objs) {
        return PageUtil.getDefaultPageList(objs, null);
    }

    public static <T> ListResultModel<List<T>> getDefaultPageList(Set<T> objs) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(objs);
        return PageUtil.getDefaultPageList(result, null);
    }

    public static <T, K> ListResultModel<List<T>> getDefaultPageList(Set<K> objs, Class<T> clazz) {
        ArrayList<K> result = new ArrayList<K>();
        result.addAll(objs);
        return PageUtil.getDefaultPageList(result, clazz);
    }

    public static <T, K> ListResultModel<List<T>> getDefaultPageList(ListResultModel<List<K>> objs, Class<T> clazz) {
        ListResultModel<List<List<T>>> userStatusInfo = new ListResultModel<List<List<T>>>();
        try {
            ArrayList pageResult = new ArrayList();
            List list = (List)objs.get();
            userStatusInfo.setData(PageUtil.fillObj(list, clazz));
            userStatusInfo.setSize(objs.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }

    public static <T, K> ListResultModel<List<T>> getDefaultPageList(List<K> objs, Class<T> clazz) {
        ListResultModel userStatusInfo = null;
        try {
            Object pageIndex = JDSActionContext.getActionContext().getParams(BaseParamsEnums.pageIndex.name());
            Object pageSize = JDSActionContext.getActionContext().getParams(BaseParamsEnums.pageSize.name());
            pageIndex = pageIndex == null ? Integer.valueOf(1) : Integer.valueOf(pageIndex.toString());
            pageSize = pageSize == null ? Integer.valueOf(100) : Integer.valueOf(pageSize.toString());
            userStatusInfo = PageUtil.getPageList(objs, (Integer)pageIndex, (Integer)pageSize, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel<List<T>>();
            userStatusInfo.setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }
}

