/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.util;

import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import com.ds.common.util.java.DynamicClassLoader;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.jds.core.User;
import com.ds.web.RequestMethodBean;
import com.ds.web.RequestParamBean;
import com.ds.web.annotation.Entity;
import com.ds.web.annotation.ViewType;
import com.ds.web.util.AnnotationUtil;
import com.ds.web.util.JSONGenUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.springframework.web.bind.annotation.RequestBody;

public class MethodUtil {
    private static String ShiftStr = "\n";
    private static String LNStr = "\n      ";

    public static List<RequestParamBean> getParams(Method sourceMethod) throws NotFoundException, ClassNotFoundException {
        List<Object> paramBeans = new ArrayList();
        CtMethod ctmethod = MethodUtil.getCtMethod(sourceMethod);
        paramBeans = ctmethod != null ? MethodUtil.getCtParams(ctmethod) : MethodUtil.getInnerParams(sourceMethod);
        return paramBeans;
    }

    static boolean checkParams(Class<?>[] classes, CtClass[] ctClasses) {
        if (classes.length != ctClasses.length) {
            return false;
        }
        int i = 0;
        for (Class<?> clazz : classes) {
            CtClass ctClass = ctClasses[i];
            if (!clazz.getName().equals(ctClass.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isGetMethod(Method method) {
        if (method.getName().startsWith("get") && !method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
            return true;
        }
        return method.getName().startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class)) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    public static boolean isSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getReturnType().equals(Void.TYPE);
    }

    public static Boolean isFieldName(Method method) {
        Boolean isField = false;
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE)) {
            isField = true;
        } else if (method.getName().startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class)) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE)) {
            isField = true;
        } else if (method.getName().startsWith("set") && method.getReturnType().equals(Void.TYPE)) {
            isField = true;
        }
        return isField;
    }

    public static String getFieldName(Method method) {
        String fieldName = null;
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE)) {
            fieldName = method.getName().substring("get".length());
        } else if (method.getName().startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class)) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE)) {
            fieldName = method.getName().substring("is".length());
        } else if (method.getName().startsWith("set") && method.getReturnType().equals(Void.TYPE)) {
            fieldName = method.getName().substring("set".length());
        }
        fieldName = fieldName != null ? StringUtility.formatJavaName(fieldName, false) : method.getName();
        return fieldName;
    }

    public static CtMethod getCtMethod(Method method) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctClazz = pool.getCtClass(method.getDeclaringClass().getName());
        for (CtMethod ctmethod : ctClazz.getDeclaredMethods()) {
            if (!ctmethod.getName().equals(method.getName()) || !MethodUtil.checkParams(method.getParameterTypes(), ctmethod.getParameterTypes())) continue;
            return ctmethod;
        }
        return null;
    }

    public static boolean checkType(String clazz) {
        if (clazz.equals("int")) {
            return false;
        }
        if (clazz.equals("long")) {
            return false;
        }
        if (clazz.equals("short")) {
            return false;
        }
        if (clazz.equals("long")) {
            return false;
        }
        if (clazz.equals("byte")) {
            return false;
        }
        if (clazz.equals("[B")) {
            return false;
        }
        if (clazz.equals("float")) {
            return false;
        }
        if (clazz.equals("double")) {
            return false;
        }
        if (clazz.equals("boolean")) {
            return false;
        }
        if (clazz.equals("void")) {
            return false;
        }
        return !clazz.startsWith("java.lang");
    }

    public static Method getSourceMethod(CtMethod ctmethod) throws ClassNotFoundException, NotFoundException {
        String name = ctmethod.getDeclaringClass().getName();
        Class clazz = ClassUtility.loadClass(name);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(ctmethod.getName()) || !MethodUtil.checkParams(method.getParameterTypes(), ctmethod.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    private static List<RequestParamBean> getInnerParams(Method sourceMethod) {
        ArrayList<RequestParamBean> paramBeans = new ArrayList<RequestParamBean>();
        Annotation[][] annotations = sourceMethod.getParameterAnnotations();
        Type[] parameterTypes = sourceMethod.getGenericParameterTypes();
        Class<?>[] parameterClasses = sourceMethod.getParameterTypes();
        String[] paramNames = new String[parameterTypes.length];
        TreeMap sortMap = new TreeMap();
        Parameter[] parameters = sourceMethod.getParameters();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if ((paramName == null || paramName.equals("null") || paramName.equals("")) && parameters != null && parameters.length > i) {
                paramName = parameters[i].getName();
            }
            HashSet<Annotation> annotationSet = new HashSet<Annotation>();
            for (Annotation annotationType : annotations[i]) {
                annotationSet.add(annotationType);
            }
            RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i], parameterClasses[i]);
            paramBeans.add(paramBean);
        }
        return paramBeans;
    }

    public static List<RequestParamBean> getCtParams(CtMethod ctmethod) throws ClassNotFoundException, NotFoundException {
        Method sourceMethod = MethodUtil.getSourceMethod(ctmethod);
        ArrayList<RequestParamBean> paramBeans = new ArrayList<RequestParamBean>();
        MethodInfo methodInfo = ctmethod.getMethodInfo();
        Object[][] annotations = ctmethod.getParameterAnnotations();
        Type[] parameterTypes = sourceMethod.getGenericParameterTypes();
        Class<?>[] parameterClasses = sourceMethod.getParameterTypes();
        String[] paramNames = new String[parameterTypes.length];
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            int pos;
            LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            TreeMap<Integer, String> sortMap = new TreeMap<Integer, String>();
            int n = pos = Modifier.isStatic((int)ctmethod.getModifiers()) ? 0 : 1;
            if (attr != null) {
                for (int i = 0; i < attr.tableLength(); ++i) {
                    sortMap.put(attr.index(i), attr.variableName(i));
                    if (attr.index(i) < pos || attr.index(i) >= paramNames.length + pos) continue;
                    paramNames[attr.index((int)i) - pos] = attr.variableName(i);
                }
            }
        }
        Parameter[] parameters = sourceMethod.getParameters();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if ((paramName == null || paramName.equals("null") || paramName.equals("")) && parameters != null && parameters.length > i) {
                paramName = parameters[i].getName();
            }
            HashSet<Annotation> annotationSet = new HashSet<Annotation>();
            for (Object annotationType : annotations[i]) {
                annotationSet.add((Annotation)annotationType);
            }
            RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i], parameterClasses[i]);
            paramBeans.add(paramBean);
        }
        return paramBeans;
    }

    public static StringBuffer toMethodStr(RequestMethodBean bean, String javaName, boolean requestBody) throws ClassNotFoundException {
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append(MethodUtil.toReturnStr(bean.getSourceMethod(), null, javaName));
        methodBuffer.append(bean.getSourceMethod().getName());
        methodBuffer.append(" (");
        Set<RequestParamBean> paramBeans = bean.getParamSet();
        for (RequestParamBean paramBean : paramBeans) {
            if (paramBean.getAnnotations().size() > 0) {
                methodBuffer.append(AnnotationUtil.toAnnotationStr(paramBean.getAnnotations().iterator().next()));
                methodBuffer.append(" ");
            }
            try {
                methodBuffer = MethodUtil.toType(bean.getName(), javaName, methodBuffer, paramBean.getParamType(), false);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            methodBuffer.append(" " + paramBean.getParamName());
            methodBuffer.append(",");
        }
        if (methodBuffer.toString().endsWith(",")) {
            methodBuffer.deleteCharAt(methodBuffer.length() - 1);
        }
        methodBuffer.append(")");
        return methodBuffer;
    }

    public static StringBuffer toMethodProxyStr(RequestMethodBean bean, ViewType viewType, String javaName, String sourceMethodName) throws ClassNotFoundException {
        StringBuffer methodBuffer = new StringBuffer();
        if (sourceMethodName == null || sourceMethodName.equals("")) {
            sourceMethodName = "getProxy()";
        }
        Method method = bean.getSourceMethod();
        StringBuffer allBuffer = new StringBuffer();
        allBuffer.append(LNStr);
        allBuffer.append(MethodUtil.toReturnStr(method, viewType, javaName));
        allBuffer.append("resultModel=new ");
        allBuffer.append(MethodUtil.toReturnStr(method, viewType, javaName) + "();");
        allBuffer.append(LNStr);
        Class innerClass = method.getReturnType();
        if (innerClass.equals(Void.TYPE)) {
            methodBuffer.append(sourceMethodName + ".");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(";");
        } else if (!ResultModel.class.isAssignableFrom(innerClass)) {
            if (innerClass.isArray() || Collection.class.isAssignableFrom(innerClass)) {
                innerClass = JSONGenUtil.getInnerReturnType(method);
                methodBuffer.append("resultModel=PageUtil.getDefaultPageList(" + sourceMethodName + ".");
                methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                methodBuffer.append(",");
                methodBuffer.append(javaName + ".class");
                methodBuffer.append(");");
            } else {
                innerClass = JSONGenUtil.getInnerReturnType(method);
                if (!MethodUtil.checkType(innerClass.getSimpleName()) || innerClass.equals(String.class)) {
                    methodBuffer.append("resultModel.setData(");
                    methodBuffer.append(sourceMethodName + ".");
                    methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                    methodBuffer.append(");");
                } else {
                    methodBuffer.append("resultModel.setData(new ");
                    methodBuffer.append(javaName + "(" + sourceMethodName + ".");
                    methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                    methodBuffer.append(")");
                    methodBuffer.append(");");
                }
            }
        } else if (ListResultModel.class.isAssignableFrom(innerClass)) {
            Class realClass = JSONGenUtil.getInnerReturnType(method);
            methodBuffer.append("resultModel=PageUtil.changPageList(" + sourceMethodName + ".");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(javaName + ".class");
            methodBuffer.append(");");
        } else {
            Class realClass = JSONGenUtil.getInnerReturnType(method);
            methodBuffer.append("resultModel.setData(new ");
            methodBuffer.append(javaName + "(" + sourceMethodName + ".");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(".getData()));");
        }
        methodBuffer.append(LNStr);
        if (method.getExceptionTypes().length > 0) {
            methodBuffer = MethodUtil.toException(methodBuffer);
        }
        allBuffer.append(methodBuffer);
        allBuffer.append(LNStr);
        allBuffer.append("return resultModel;");
        allBuffer.append(LNStr);
        return allBuffer;
    }

    public static StringBuffer toException(StringBuffer methodBuffer) {
        StringBuffer exceptionBuffer = new StringBuffer();
        exceptionBuffer.append(LNStr);
        exceptionBuffer.append("try{");
        exceptionBuffer.append(LNStr + "  ");
        exceptionBuffer.append(methodBuffer);
        exceptionBuffer.append(LNStr);
        exceptionBuffer.append("} catch (Exception e) {");
        exceptionBuffer.append(LNStr);
        exceptionBuffer.append("  e.printStackTrace();");
        exceptionBuffer.append(LNStr);
        exceptionBuffer.append("}");
        return exceptionBuffer;
    }

    public static StringBuffer toInnerMethodStr(CtMethod ctmethod) {
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append(ctmethod.getName());
        methodBuffer.append("(");
        List<RequestParamBean> paramBeans = null;
        try {
            paramBeans = MethodUtil.getCtParams(ctmethod);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (RequestParamBean paramBean : paramBeans) {
            methodBuffer.append(paramBean.getParamName());
            methodBuffer.append(",");
        }
        if (methodBuffer.toString().endsWith(",")) {
            methodBuffer.deleteCharAt(methodBuffer.length() - 1);
        }
        methodBuffer.append(")");
        return methodBuffer;
    }

    public static StringBuffer toInnerMethodStr(Method method) {
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append(method.getName());
        methodBuffer.append("(");
        List<RequestParamBean> paramBeans = null;
        try {
            paramBeans = MethodUtil.getParams(method);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (RequestParamBean paramBean : paramBeans) {
            methodBuffer.append(paramBean.getParamName());
            methodBuffer.append(",");
        }
        if (methodBuffer.toString().endsWith(",")) {
            methodBuffer.deleteCharAt(methodBuffer.length() - 1);
        }
        methodBuffer.append(")");
        return methodBuffer;
    }

    public static StringBuffer toMethodProxyStr(Method method, ViewType viewType, String javaName, String sourceMethodName) {
        if (sourceMethodName == null || sourceMethodName.equals("")) {
            sourceMethodName = "getProxy()";
        }
        StringBuffer allBuffer = new StringBuffer();
        allBuffer.append(LNStr);
        allBuffer.append(MethodUtil.toReturnStr(method, viewType, javaName));
        allBuffer.append("resultModel=new ");
        allBuffer.append(MethodUtil.toReturnStr(method, viewType, javaName) + "();");
        allBuffer.append(LNStr);
        StringBuffer methodBuffer = new StringBuffer();
        Class innerClass = method.getReturnType();
        if (innerClass.equals(Void.TYPE)) {
            methodBuffer.append("getProxy().");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(";");
        } else if (!ResultModel.class.isAssignableFrom(innerClass)) {
            if (innerClass.isArray() || Collection.class.isAssignableFrom(innerClass)) {
                innerClass = JSONGenUtil.getInnerReturnType(method);
                methodBuffer.append("resultModel=PageUtil.getDefaultPageList(" + sourceMethodName + ".");
                methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                methodBuffer.append(",");
                methodBuffer.append(javaName + ".class");
                methodBuffer.append(");");
            } else {
                innerClass = JSONGenUtil.getInnerReturnType(method);
                if (!MethodUtil.checkType(innerClass.getSimpleName()) || innerClass.equals(String.class)) {
                    methodBuffer.append("resultModel.setData(");
                    methodBuffer.append(sourceMethodName + ".");
                    methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                    methodBuffer.append(");");
                } else {
                    methodBuffer.append("resultModel.setData(new ");
                    methodBuffer.append(javaName + "(" + sourceMethodName + ".");
                    methodBuffer.append(MethodUtil.toInnerMethodStr(method));
                    methodBuffer.append(")");
                    methodBuffer.append(");");
                }
            }
        } else if (ListResultModel.class.isAssignableFrom(innerClass)) {
            methodBuffer.append("resultModel=PageUtil.changPageList(" + sourceMethodName + ".");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(",");
            methodBuffer.append(javaName + ".class");
            methodBuffer.append(");");
        } else {
            methodBuffer.append("resultModel.setData(new ");
            methodBuffer.append(javaName + "(" + sourceMethodName + ".");
            methodBuffer.append(MethodUtil.toInnerMethodStr(method));
            methodBuffer.append(".getData()));");
        }
        methodBuffer.append(LNStr);
        if (method.getExceptionTypes().length > 0) {
            methodBuffer = MethodUtil.toException(methodBuffer);
        }
        allBuffer.append(methodBuffer);
        allBuffer.append(LNStr);
        allBuffer.append("return resultModel;");
        allBuffer.append(LNStr);
        return allBuffer;
    }

    public static StringBuffer toFieldStr(Method method, String javaName, String fieldName) {
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append(MethodUtil.toReturnStr(method, null, javaName));
        methodBuffer.append(" " + fieldName);
        methodBuffer.append(";");
        return methodBuffer;
    }

    public static StringBuffer toMethodStr(Method method, ViewType viewType, String javaName, boolean requestBody) {
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append(MethodUtil.toReturnStr(method, viewType, javaName));
        methodBuffer.append(method.getName());
        methodBuffer.append(" (");
        try {
            List<RequestParamBean> paramBeans = MethodUtil.getParams(method);
            for (RequestParamBean paramBean : paramBeans) {
                if (paramBean.getAnnotations().size() > 0) {
                    methodBuffer.append(AnnotationUtil.toAnnotationStr(paramBean.getAnnotations().iterator().next()));
                    methodBuffer.append(" ");
                } else if (requestBody) {
                    methodBuffer.append("@RequestBody ");
                }
                methodBuffer = MethodUtil.toType(method.getName(), paramBean.getParamClass().getSimpleName(), methodBuffer, paramBean.getParamType(), false);
                methodBuffer.append(" " + paramBean.getParamName());
                methodBuffer.append(",");
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (methodBuffer.toString().endsWith(",")) {
            methodBuffer.deleteCharAt(methodBuffer.length() - 1);
        }
        methodBuffer.append(")");
        return methodBuffer;
    }

    public static StringBuffer toReturnPrxoyStr(Method method, String javaName) {
        StringBuffer methodBuffer = new StringBuffer();
        Type type = method.getGenericReturnType();
        Class<?> clazz = method.getReturnType();
        if (!ResultModel.class.isAssignableFrom(clazz)) {
            if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                methodBuffer.append(ListResultModel.class.getSimpleName() + "<");
            } else {
                methodBuffer.append(ResultModel.class.getSimpleName() + "<");
            }
        }
        try {
            String methodName = StringUtility.formatJavaName(method.getName(), true);
            methodBuffer = MethodUtil.toType(methodName, javaName, methodBuffer, type, true);
            if (!ResultModel.class.isAssignableFrom(clazz)) {
                methodBuffer.append(">");
            }
            methodBuffer.append(" ");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return methodBuffer;
    }

    public static StringBuffer toReturnStr(Method method, ViewType viewType, String javaName) {
        StringBuffer methodBuffer = new StringBuffer();
        Type type = method.getGenericReturnType();
        Class<?> clazz = method.getReturnType();
        if (!ResultModel.class.isAssignableFrom(clazz)) {
            if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                if (viewType != null && (viewType.equals(ViewType.navtree) || viewType.equals(ViewType.tree))) {
                    methodBuffer.append(TreeListResultModel.class.getSimpleName() + "<");
                } else {
                    methodBuffer.append(ListResultModel.class.getSimpleName() + "<");
                }
            } else {
                methodBuffer.append(ResultModel.class.getSimpleName() + "<");
            }
        }
        try {
            methodBuffer = MethodUtil.toType(method.getName(), javaName, methodBuffer, type, true);
            if (!ResultModel.class.isAssignableFrom(clazz)) {
                methodBuffer.append(">");
            }
            methodBuffer.append(" ");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return methodBuffer;
    }

    public ListResultModel<List<User>> test(@RequestBody User arg0, Map<String, User> arg1) throws Exception {
        ListResultModel<List<User>> resultModel = new ListResultModel<List<User>>();
        return resultModel;
    }

    public static StringBuffer toWildcardType(StringBuffer methodBuffer, WildcardType type) throws ClassNotFoundException {
        if (type.getTypeName().equals("?")) {
            methodBuffer.append(type.getTypeName());
        } else if (type.getTypeName().startsWith("?") && type.getUpperBounds().length > 0) {
            methodBuffer.append("? extends ");
            methodBuffer.append(((Class)type.getUpperBounds()[0]).getSimpleName());
        }
        return methodBuffer;
    }

    public static StringBuffer toType(String methodName, String javaName, StringBuffer methodBuffer, Type type, Boolean isProxy) throws ClassNotFoundException {
        if (type.equals(Void.TYPE)) {
            methodBuffer.append(Boolean.class.getSimpleName());
        } else if (type instanceof ParameterizedType) {
            methodBuffer = MethodUtil.toTypeStr(methodName, javaName, methodBuffer, (ParameterizedType)type);
        } else if (type instanceof WildcardType) {
            methodBuffer = MethodUtil.toWildcardType(methodBuffer, (WildcardType)type);
        } else if (TypeUtils.loadClass((String)type.getTypeName()) != null && type instanceof Class) {
            ClassLoader classloader = TypeUtils.loadClass((String)type.getTypeName()).getClassLoader();
            Entity entity = AnnotationUtil.getClassAnnotation((Class)type, Entity.class);
            if ((classloader instanceof DynamicClassLoader || entity != null) && isProxy.booleanValue()) {
                methodBuffer.append(javaName);
            } else {
                methodBuffer.append(TypeUtils.loadClass((String)type.getTypeName()).getSimpleName());
            }
        } else {
            methodBuffer.append(type.getTypeName() + " ");
        }
        return methodBuffer;
    }

    public static Set<String> getAllAnnotationClass(Annotation annotation, Set<String> classes) throws ClassNotFoundException {
        Class<Annotation> annClass = annotation.annotationType();
        if (!classes.contains(annClass.getName()) && MethodUtil.checkType(annClass.getName())) {
            while (annClass.isArray()) {
                annClass = annClass.getComponentType();
            }
            classes.add(annClass.getName());
            classes = MethodUtil.getAllClasses(annClass, classes);
        }
        return classes;
    }

    public static Set<String> getAllImports(Set<Class> clazzs, Set<String> imports) throws ClassNotFoundException {
        for (Class clazz : clazzs) {
            imports = MethodUtil.getAllClasses(clazz, imports);
        }
        imports = MethodUtil.filterImports(imports);
        return imports;
    }

    public static Set<String> getAllImports(Class clazz, Set<String> imports) throws ClassNotFoundException {
        if (clazz != null) {
            imports = MethodUtil.getAllClasses(clazz, imports);
            imports.add(clazz.getName());
            imports = MethodUtil.filterImports(imports);
        }
        return imports;
    }

    static Set<String> filterImports(Set<String> imports) {
        LinkedHashSet<String> simpleImports = new LinkedHashSet<String>();
        for (String className : imports) {
            if (className.indexOf(".") <= -1) continue;
            if (!className.endsWith("*")) {
                String packageName = className.substring(0, className.lastIndexOf("."));
                className = packageName + ".*";
            }
            if (simpleImports.contains(className)) continue;
            simpleImports.add(className);
        }
        return simpleImports;
    }

    /*
     * Could not resolve type clashes
     */
    static Set<String> getAllClasses(Class clazz, Set<String> classes) throws ClassNotFoundException {
        Method[] methods;
        Method[] declaredmethods;
        Field[] fields;
        Field[] declaredfields;
        if (classes == null) {
            classes = new LinkedHashSet<String>();
        }
        if (clazz == null) {
            return classes;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        TypeVariable<Class<T>>[] types = clazz.getTypeParameters();
        for (TypeVariable type : types) {
            classes = MethodUtil.getAllClasses(type, classes);
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            classes = MethodUtil.getAllAnnotationClass(annotation, classes);
        }
        for (Field field : declaredfields = clazz.getDeclaredFields()) {
            Set<Class> typeClasses = new LinkedHashSet<Class>();
            typeClasses = JSONGenUtil.getAllInnerReturnType(field, typeClasses);
            typeClasses.add(field.getType());
            for (Class<?> typeClass : typeClasses) {
                while (typeClass.isArray()) {
                    typeClass = typeClass.getComponentType();
                }
                if (classes.contains(typeClass.getName()) || !MethodUtil.checkType(typeClass.getName())) continue;
                classes.add(typeClass.getName());
            }
            for (Annotation annotation : field.getAnnotations()) {
                classes = MethodUtil.getAllAnnotationClass(annotation, classes);
            }
            classes = MethodUtil.getAllClasses(field.getGenericType(), classes);
        }
        for (Field field : fields = clazz.getFields()) {
            ArrayList typeClasses = new ArrayList();
            typeClasses.add(JSONGenUtil.getInnerReturnType(field));
            typeClasses.add(field.getType());
            for (Class<?> typeClass : typeClasses) {
                while (typeClass.isArray()) {
                    typeClass = typeClass.getComponentType();
                }
                if (classes.contains(typeClass.getName()) || !MethodUtil.checkType(typeClass.getName())) continue;
                classes.add(typeClass.getName());
            }
            for (Annotation annotation : field.getAnnotations()) {
                classes = MethodUtil.getAllAnnotationClass(annotation, classes);
            }
            classes = MethodUtil.getAllClasses(field.getGenericType(), classes);
        }
        for (Method method : declaredmethods = clazz.getDeclaredMethods()) {
            Annotation[][] parameterAnnotations;
            Set<Class> typeClasses = new LinkedHashSet<Class>();
            typeClasses = JSONGenUtil.getAllInnerReturnType(method, typeClasses);
            typeClasses.add(method.getReturnType());
            for (Class<?> typeClass : typeClasses) {
                while (typeClass.isArray()) {
                    typeClass = typeClass.getComponentType();
                }
                if (classes.contains(typeClass.getName()) || !MethodUtil.checkType(typeClass.getName())) continue;
                classes.add(typeClass.getName());
            }
            for (Annotation annotation : method.getAnnotations()) {
                classes = MethodUtil.getAllAnnotationClass(annotation, classes);
            }
            for (Class<?> type : method.getParameterTypes()) {
                classes = MethodUtil.getAllClasses((Type)type, classes);
            }
            Annotation[][] typeClass = parameterAnnotations = method.getParameterAnnotations();
            int annotation = typeClass.length;
            for (int type = 0; type < annotation; ++type) {
                Annotation[] annotations;
                for (Annotation annotation2 : annotations = typeClass[type]) {
                    classes = MethodUtil.getAllAnnotationClass(annotation2, classes);
                }
            }
            classes = MethodUtil.getAllClasses(method.getGenericReturnType(), classes);
        }
        for (Method method : methods = clazz.getMethods()) {
            Annotation[][] parameterAnnotations;
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annClass = annotation.annotationType();
                if (classes.contains(annClass.getName()) || !MethodUtil.checkType(annClass.getName())) continue;
                classes.add(annClass.getName());
                classes = MethodUtil.getAllClasses(annClass, classes);
            }
            Set<Class> typeClasses = new LinkedHashSet<Class>();
            typeClasses = JSONGenUtil.getAllInnerReturnType(method, typeClasses);
            typeClasses.add(method.getReturnType());
            for (Class<?> typeClass : typeClasses) {
                while (typeClass.isArray()) {
                    typeClass = typeClass.getComponentType();
                }
                if (classes.contains(typeClass.getName()) || !MethodUtil.checkType(typeClass.getName())) continue;
                classes.add(typeClass.getName());
            }
            for (Class<?> type : method.getParameterTypes()) {
                classes = MethodUtil.getAllClasses(type, classes);
            }
            Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    Class<? extends Annotation> annClass = annotation.annotationType();
                    if (classes.contains(annClass.getName()) || !MethodUtil.checkType(annClass.getName())) continue;
                    classes.add(annClass.getName());
                    classes = MethodUtil.getAllClasses(annClass, classes);
                }
            }
            classes = MethodUtil.getAllClasses(method.getGenericReturnType(), classes);
        }
        return classes;
    }

    static Set<String> getAllClasses(Type type, Set<String> classes) throws ClassNotFoundException {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            if (!classes.contains(ptype.getRawType().getTypeName()) && MethodUtil.checkType(ptype.getRawType().getTypeName())) {
                classes.add(ptype.getRawType().getTypeName());
            }
        } else if (type instanceof TypeVariable) {
            if (type.getTypeName().startsWith("?") && ((TypeVariable)type).getAnnotatedBounds().length > 0) {
                AnnotatedType[] innerTypes;
                for (AnnotatedType innerType : innerTypes = ((TypeVariable)type).getAnnotatedBounds()) {
                    if (classes.contains(innerType.getType().getTypeName()) || !MethodUtil.checkType(innerType.getType().getTypeName())) continue;
                    classes.add(innerType.getType().getTypeName());
                }
            }
        } else if (type instanceof WildcardType) {
            if (type.getTypeName().startsWith("?") && ((WildcardType)type).getUpperBounds().length > 0) {
                Type[] innerTypes;
                for (Type innerType : innerTypes = ((WildcardType)type).getUpperBounds()) {
                    if (classes.contains(innerType.getTypeName()) || !MethodUtil.checkType(innerType.getTypeName())) continue;
                    classes.add(innerType.getTypeName());
                }
            }
        } else if (type instanceof Class) {
            Class<?> typeClass = (Class<?>)type;
            if (typeClass.isArray()) {
                typeClass = typeClass.getComponentType();
            }
            if (!classes.contains(typeClass.getName()) && MethodUtil.checkType(typeClass.getName())) {
                classes.add(typeClass.getName());
            }
        } else if (!classes.contains(type.getTypeName()) && MethodUtil.checkType(type.getTypeName())) {
            classes.add(type.getTypeName());
        }
        return classes;
    }

    public static StringBuffer toTypeStr(String methodName, String javaName, StringBuffer methodBuffer, ParameterizedType type) throws ClassNotFoundException {
        Type rawTye = type.getRawType();
        if (rawTye != null) {
            if (rawTye == Map.class || rawTye == HashMap.class) {
                Type keyType = type.getActualTypeArguments()[0];
                methodBuffer.append(Map.class.getSimpleName());
                methodBuffer.append("<");
                methodBuffer = MethodUtil.toType(methodName, javaName, methodBuffer, keyType, true);
                methodBuffer.append(",");
                Type valueType = type.getActualTypeArguments()[1];
                methodBuffer = MethodUtil.toType(methodName, javaName, methodBuffer, valueType, true);
                methodBuffer.append(">");
            } else {
                if (ListResultModel.class.isAssignableFrom((Class)rawTye)) {
                    methodBuffer.append(ListResultModel.class.getSimpleName());
                } else if (rawTye == ResultModel.class) {
                    methodBuffer.append(ResultModel.class.getSimpleName());
                } else if (rawTye == TreeListResultModel.class) {
                    methodBuffer.append(TreeListResultModel.class.getSimpleName());
                } else {
                    methodBuffer = rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == Collection.class || rawTye == List.class || rawTye == ArrayList.class ? MethodUtil.toType(methodName, javaName, methodBuffer, rawTye, true) : MethodUtil.toType(methodName, javaName, methodBuffer, rawTye, true);
                }
                if (type.getActualTypeArguments() != null) {
                    methodBuffer.append("<");
                    Type itemType = type.getActualTypeArguments()[0];
                    if (itemType instanceof Class) {
                        methodBuffer.append(javaName);
                    } else {
                        methodBuffer = MethodUtil.toType(methodName, javaName, methodBuffer, itemType, false);
                    }
                    methodBuffer.append(">");
                } else {
                    methodBuffer.append(javaName + " ");
                }
            }
        }
        return methodBuffer;
    }

    public static void main(String[] args) {
        try {
            Method method = MethodUtil.class.getMethod("test", User.class, Map.class);
            StringBuffer methodBuffer = MethodUtil.toMethodProxyStr(method, null, "view", null);
            System.out.println(methodBuffer);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

