/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.invocation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.JSONGenSetInvocationHandler;
import com.ds.web.RemoteConnectionManager;
import com.ds.web.RuntimeLog;
import com.ds.web.util.JSONGenUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

public class RemoteResultModel<T>
extends ResultModel<T> {
    private Future<Content> future;
    private Class iClass;
    @JSONField(serialize=false)
    private ResultModel<T> model;
    private String url;
    private static final Log logger = LogFactory.getLog("JDS", RemoteResultModel.class);
    private static final String asyncServiceKey = "async";
    @JSONField(name="data")
    private Object dataObj;

    RemoteResultModel(String url, final String token, Request request, final Class iClass, Async async) {
        this.iClass = iClass;
        this.url = url;
        this.token = token;
        if (System.getProperty("JDShttpProxy") != null) {
            request.viaProxy(System.getProperty("JDShttpProxy"));
        }
        this.future = async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
                if (!InputStream.class.isAssignableFrom(iClass)) {
                    String json = content.asString();
                    logger.debug("return " + json);
                    RuntimeLog log = ConnectionLogFactory.getInstance().getLog(token);
                    if (log != null) {
                        logger.info("url= " + log.getUrl() + "requestJSON=" + log.getRequestJson() + " times=" + (System.currentTimeMillis() - log.getStartTime()));
                        log.setBodyJson(json);
                        log.setEndTime(System.currentTimeMillis());
                        log.setTime(log.getEndTime() - log.getStartTime());
                    }
                }
            }

            public void cancelled() {
            }
        });
    }

    @Override
    public void execute() {
        ExecutorService service = RemoteConnectionManager.getConntctionService(asyncServiceKey);
        service.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteResultModel.this.get();
                }
                catch (JDSException e) {
                    logger.error("url==" + RemoteResultModel.this.url);
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public int getRequestStatus() {
        int status = -1;
        try {
            status = this.getModel().getRequestStatus();
        }
        catch (JDSException jDSException) {
            // empty catch block
        }
        return status;
    }

    @JSONField(serialize=false)
    public ResultModel<T> getModel() throws JDSException {
        if (this.model == null) {
            this.get();
        }
        return this.model;
    }

    @Override
    @JSONField(serialize=false)
    public T getData() {
        T data = null;
        try {
            data = this.get();
        }
        catch (JDSException e) {
            this.setRequestStatus(-1);
        }
        return data;
    }

    public Object getDataObj() {
        this.getData();
        return this.dataObj;
    }

    @JSONField(serialize=false)
    Future<Content> getFuture() {
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws JDSException {
        try {
            Content content = this.future.get();
            if (InputStream.class.isAssignableFrom(this.iClass) && content.getType().getMimeType().toString().equals(ContentType.APPLICATION_OCTET_STREAM.toString())) {
                return (T)content.asStream();
            }
            String modelStr = content.asString();
            return this.getResultModel(modelStr).getData();
        }
        catch (InterruptedException e) {
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
        catch (ExecutionException e) {
            if (e instanceof JDSException) {
                throw (JDSException)e;
            }
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
    }

    @Override
    public T get() throws JDSException {
        try {
            Content content = this.future.get();
            if (InputStream.class.isAssignableFrom(this.iClass) && content.getType().getMimeType().toString().equals(ContentType.APPLICATION_OCTET_STREAM.toString())) {
                return (T)content.asStream();
            }
            String modelStr = this.future.get().asString();
            return this.getResultModel(modelStr).getData();
        }
        catch (InterruptedException e) {
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
        catch (ExecutionException e) {
            if (e instanceof JDSException) {
                throw (JDSException)e;
            }
            throw new JDSException("\u670d\u52a1\u5668\u5f02\u5e38", 500);
        }
    }

    @Override
    @JSONField(serialize=false)
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    @JSONField(serialize=false)
    public boolean isDone() {
        return this.future.isDone();
    }

    @JSONField(serialize=false)
    ResultModel<T> getResultModel(String modelStr) throws JDSException {
        Object obj = null;
        JSONObject jsonObj = JSONObject.parseObject((String)modelStr);
        if (jsonObj == null || jsonObj.get((Object)"requestStatus") == null) {
            throw new JDSException("\u670d\u52a1\u5668\u683c\u5f0f\u9519\u8bef:" + modelStr, 500);
        }
        if (Integer.valueOf(jsonObj.get((Object)"requestStatus").toString()) == 0) {
            this.requestStatus = Integer.valueOf(jsonObj.get((Object)"requestStatus").toString());
            this.dataObj = jsonObj.get((Object)"data");
            if (this.dataObj == null) {
                this.model = new ResultModel();
                if (Boolean.class.isAssignableFrom(this.iClass)) {
                    this.model.setData(Boolean.TRUE);
                    obj = Boolean.TRUE;
                }
            } else if (this.dataObj instanceof String || this.dataObj instanceof Boolean || this.dataObj instanceof Integer || this.dataObj instanceof Long || this.dataObj.getClass().isPrimitive()) {
                this.model = new ResultModel();
                Object vlaue = TypeUtils.cast((Object)this.dataObj, (Class)this.iClass, null);
                this.model.setData(vlaue);
            } else if (this.dataObj instanceof JSONArray) {
                Integer size;
                Class jsonClass = this.iClass;
                JSONArray arr = (JSONArray)this.dataObj;
                jsonClass = JSONGenUtil.fillSetMethod(this.iClass);
                if (!jsonClass.equals(this.iClass)) {
                    List josnobj = JSONArray.parseArray((String)jsonObj.getString("data"), (Class)jsonClass);
                    ArrayList<Object> rmObj = new ArrayList<Object>();
                    for (Object json : josnobj) {
                        Object proxyObj = null;
                        if (json != null) {
                            proxyObj = Enhancer.create(Object.class, (Class[])new Class[]{this.iClass}, (Callback)new JSONGenSetInvocationHandler(json));
                        }
                        rmObj.add(proxyObj);
                        obj = rmObj;
                    }
                } else {
                    obj = JSONArray.parseArray((String)jsonObj.getString("data"), (Class)this.iClass);
                }
                if ((size = jsonObj.getInteger("size")) != null) {
                    ListResultModel listResultModel = new ListResultModel();
                    listResultModel.setSize(size);
                    this.model = listResultModel;
                } else {
                    this.model = new ResultModel();
                }
                this.model.setData(obj);
            } else if (this.dataObj instanceof JSONObject) {
                Class jsonClass = JSONGenUtil.fillSetMethod(this.iClass);
                if (!jsonClass.equals(this.iClass)) {
                    obj = JSONObject.parseObject((String)jsonObj.getString("data"), (Class)jsonClass);
                    if (obj != null) {
                        obj = Enhancer.create(Object.class, (Class[])new Class[]{this.iClass}, (Callback)new JSONGenSetInvocationHandler(obj));
                    }
                } else {
                    obj = JSONObject.parseObject((String)jsonObj.getString("data"), (Class)this.iClass);
                }
                this.model = new ResultModel();
                this.model.setData(obj);
            } else if (this.dataObj instanceof JSONObject) {
                Class jsonClass = JSONGenUtil.fillSetMethod(this.iClass);
                if (!jsonClass.equals(this.iClass)) {
                    obj = JSONObject.parseObject((String)jsonObj.getString("data"), (Class)jsonClass);
                    if (obj != null) {
                        obj = Enhancer.create(Object.class, (Class[])new Class[]{this.iClass}, (Callback)new JSONGenSetInvocationHandler(obj));
                    }
                } else {
                    obj = JSONObject.parseObject((String)jsonObj.getString("data"), (Class)this.iClass);
                }
                this.model = new ResultModel();
                this.model.setData(obj);
            }
        } else {
            ErrorResultModel errmodel;
            Integer errcode = (Integer)jsonObj.get((Object)"errCode");
            String errdes = (String)jsonObj.get((Object)"errDes");
            this.model = errmodel = (ErrorResultModel)JSONObject.parseObject((String)modelStr, ErrorResultModel.class);
            throw new JDSException(errmodel.getErrdes(), errmodel.getErrcode());
        }
        return this.model;
    }

    private T newProxy(Class<T> clazz) {
        MethodInterceptor staticMethodInterceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] objects, MethodProxy proxy) {
                String name = method.getName();
                Object returnobj = null;
                try {
                    returnobj = method.invoke(returnobj, objects);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return returnobj;
            }
        };
        Object obj = Enhancer.create(Object.class, (Class[])new Class[]{clazz}, (Callback)staticMethodInterceptor);
        return (T)obj;
    }
}

