/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web.client;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.StringUtility;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esb.config.JDSBusException;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.config.manager.ServiceConfigManager;
import com.ds.web.util.AnnotationUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class SpringMVCTempLoadProxy
implements ServiceConfigManager {
    private static final Log logger = LogFactory.getLog("JDS", SpringMVCTempLoadProxy.class);
    private final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private final String defaulePath = "com.ds";
    private final EsbBean esbBean;
    List<ServiceBean> remoteBeans = new ArrayList<ServiceBean>();
    Map<String, ServiceBean> remoteBeanMap = new HashMap<String, ServiceBean>();
    Map<String, ServiceBean> nameBeanMap = new HashMap<String, ServiceBean>();

    public SpringMVCTempLoadProxy(EsbBean esbBean) {
        this.esbBean = esbBean;
        esbBean.getPath();
    }

    @Override
    public ServiceBean getServiceConfigById(String id) {
        return this.remoteBeanMap.get(id);
    }

    @Override
    public ServiceBean getServiceConfigByName(String name) {
        return this.nameBeanMap.get(name);
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapByName() {
        return this.remoteBeanMap;
    }

    @Override
    public Map<String, ServiceBean> findServiceConfigMapById() {
        return this.remoteBeanMap;
    }

    @Override
    public List<ServiceBean> loadAllService() {
        return this.remoteBeans;
    }

    @Override
    public Set<Class<?>> init() throws JDSBusException {
        String path = this.esbBean.getPath();
        if (path != null && path.indexOf(";") > -1) {
            String[] paths;
            for (String packetPath : paths = StringUtility.split(";", path)) {
                this.scannerPackages(packetPath);
            }
        } else {
            this.scannerPackages("com.ds");
        }
        return null;
    }

    private Set<Class<?>> scannerPackages(String basePackage) {
        ResourcePatternResolver resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(null);
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        LinkedHashSet set = new LinkedHashSet();
        String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + '/' + "**/*.class";
        try {
            Resource[] resources;
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                String className = metadataReader.getClassMetadata().getClassName();
                try {
                    Class<?> clazz = Class.forName(className);
                    this.fullExpressionTempBean(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return set;
    }

    public void fullExpressionTempBean(Class clazz) {
        ExpressionTempBean expressionTempBean = null;
        if (clazz.isAnnotationPresent(EsbBeanAnnotation.class)) {
            EsbBeanAnnotation esbBeanAnnotation = AnnotationUtil.getClassAnnotation(clazz, EsbBeanAnnotation.class);
            expressionTempBean = new ExpressionTempBean();
            String name = esbBeanAnnotation.name();
            String id = esbBeanAnnotation.id();
            expressionTempBean.setDataType(esbBeanAnnotation.dataType());
            if (esbBeanAnnotation.dataType().equals("server")) {
                expressionTempBean.setExpressionArr("GetClientService(\"" + clazz.getName() + "\",\"" + esbBeanAnnotation.serverUrl() + "\")");
            } else {
                expressionTempBean.setExpressionArr(esbBeanAnnotation.expressionArr());
            }
            expressionTempBean.setServerUrl(esbBeanAnnotation.serverUrl());
            expressionTempBean.setId(id);
            expressionTempBean.setJspUrl(esbBeanAnnotation.jspUrl());
            expressionTempBean.setDesc(esbBeanAnnotation.desc());
            expressionTempBean.setName(name);
            expressionTempBean.setMainClass(clazz.getName());
            expressionTempBean.setReturntype(esbBeanAnnotation.expressionArr().substring(0, esbBeanAnnotation.expressionArr().indexOf("(")));
            expressionTempBean.setClazz(clazz.getName());
            this.remoteBeans.add(expressionTempBean);
            this.remoteBeanMap.put(id, expressionTempBean);
            this.nameBeanMap.put(name, expressionTempBean);
        }
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)basePackage);
    }
}

