/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.enums.db.MethodChinaName;
import com.ds.enums.service.HttpMethod;
import com.ds.enums.service.RequestType;
import com.ds.enums.service.ResponseType;
import com.ds.org.conf.OrgConstants;
import com.ds.web.RequestMappingBean;
import com.ds.web.RequestParamBean;
import com.ds.web.util.AnnotationUtil;
import com.ds.web.util.JSONGenUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class RequestMethodBean {
    @JSONField(serialize=false)
    public Method method;
    @JSONField(serialize=false)
    public CtMethod ctmethod;
    public RequestMappingBean mappingBean;
    public String url;
    public String domainId;
    public String name;
    public String className;
    public String methodName;
    public String pathVariable;
    public ResponseBody responseBody;
    public RequestBody requestBody;
    public MethodChinaName methodChinaName;
    public Map<String, PathVariable> pathVariables = new HashMap<String, PathVariable>();
    public HttpMethod queryMethod = HttpMethod.POST;
    public RequestType requestType = RequestType.FORM;
    public ResponseType responseType = ResponseType.JSON;
    public Set<RequestParamBean> paramSet = new LinkedHashSet<RequestParamBean>();
    public Map<String, String> paramsMap = new LinkedHashMap<String, String>();
    public Map<String, Object> defaultParamsValueMap = new LinkedHashMap<String, Object>();
    public Set<String> requiredParams = new HashSet<String>();
    private static final Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), RequestMethodBean.class);

    public RequestMethodBean(Method method, RequestMappingBean mappingBean, String domainId) {
        this.method = method;
        this.className = method.getDeclaringClass().getName();
        this.mappingBean = mappingBean;
        this.domainId = domainId;
        this.init(method);
    }

    void init(Method sourceMethod) {
        RequestMapping requestMapping = AnnotationUtil.getMethodAnnotation(sourceMethod, RequestMapping.class);
        if (requestMapping != null && this.mappingBean != null) {
            this.mappingBean = new RequestMappingBean(requestMapping, this.mappingBean.getParentPath());
        }
        Type[] parameterTypes = sourceMethod.getGenericParameterTypes();
        Class<?>[] parameterClasses = sourceMethod.getParameterTypes();
        String[] paramNames = new String[parameterTypes.length];
        Set<RequestMethod> methods = this.mappingBean.getMethod();
        Annotation[][] annotations = sourceMethod.getParameterAnnotations();
        this.requestType = RequestType.FORM;
        this.methodName = sourceMethod.getName();
        this.url = this.mappingBean.getFristUrl();
        this.responseBody = AnnotationUtil.getMethodAnnotation(sourceMethod, ResponseBody.class);
        this.methodChinaName = AnnotationUtil.getMethodAnnotation(sourceMethod, MethodChinaName.class);
        this.name = this.methodName;
        if (this.mappingBean.getName() != null && !this.mappingBean.getName().equals("")) {
            this.name = this.mappingBean.getName();
        }
        if (methods != null && methods.size() > 0) {
            this.queryMethod = methods.size() > 1 ? HttpMethod.auto : HttpMethod.fromType(methods.iterator().next().name());
        } else {
            this.responseType = this.responseBody != null ? ResponseType.JSON : ResponseType.TEXT;
        }
        if (this.requestType.equals(RequestType.JSON)) {
            Method[] ctMethods;
            Class<?> clazz = parameterClasses[0];
            for (Method method : ctMethods = clazz.getDeclaredMethods()) {
                if (!method.getName().startsWith("get")) continue;
                String fileName = method.getName().substring(3, method.getName().length());
                if (fileName.length() > 0) {
                    fileName = fileName.substring(0, 1).toLowerCase() + fileName.substring(1, fileName.length());
                } else {
                    System.out.println(method.getName() + method);
                }
                this.paramsMap.put(fileName, method.getReturnType().getName());
            }
        } else {
            Parameter[] parameters = sourceMethod.getParameters();
            for (int i = 0; i < paramNames.length; ++i) {
                RequestParam paramAnnotation;
                String paramName = paramNames[i];
                Parameter parameter = parameters[i];
                if ((paramName == null || paramName.equals("null") || paramName.equals("")) && parameters != null && parameters.length > i) {
                    paramName = parameters[i].getName();
                }
                if ((paramAnnotation = parameter.getAnnotation(RequestParam.class)) != null) {
                    if (!paramAnnotation.value().equals("")) {
                        paramName = paramAnnotation.value();
                    }
                    if (!paramAnnotation.defaultValue().equals("")) {
                        this.defaultParamsValueMap.put(paramName, paramAnnotation.defaultValue());
                    }
                    if (paramAnnotation.required()) {
                        this.requiredParams.add(paramName);
                    }
                }
                HashSet<Annotation> annotationSet = new HashSet<Annotation>();
                for (Annotation annotationType : annotations[i]) {
                    annotationSet.add(annotationType);
                }
                RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i], parameterClasses[i]);
                this.paramSet.add(paramBean);
                this.paramsMap.put(paramName, parameterClasses[i].getName());
            }
        }
    }

    public RequestMethodBean(CtMethod ctmethod, RequestMappingBean mapping, String domainId) {
        this.ctmethod = ctmethod;
        this.mappingBean = mapping;
        this.methodName = ctmethod.getName();
        this.className = ctmethod.getDeclaringClass().getName();
        try {
            MethodInfo methodInfo = ctmethod.getMethodInfo();
            Object[][] annotations = ctmethod.getAvailableParameterAnnotations();
            if (this.getSourceMethod() != null) {
                Type[] parameterTypes = this.getSourceMethod().getGenericParameterTypes();
                Class<?>[] parameterClasses = this.getSourceMethod().getParameterTypes();
                String[] paramNames = new String[parameterTypes.length];
                Set<RequestMethod> methods = mapping.getMethod();
                this.requestType = RequestType.FORM;
                this.methodName = methodInfo.getName();
                this.url = this.mappingBean.getFristUrl();
                this.responseBody = AnnotationUtil.getMethodAnnotation(this.getSourceMethod(), ResponseBody.class);
                this.methodChinaName = AnnotationUtil.getMethodAnnotation(this.getSourceMethod(), MethodChinaName.class);
                this.name = this.methodName;
                if (this.mappingBean.getName() != null && !this.mappingBean.getName().equals("")) {
                    this.name = this.mappingBean.getName();
                } else if (this.mappingBean.getValue() != null && this.mappingBean.getValue().size() > 0) {
                    this.name = this.mappingBean.getValue().iterator().next();
                }
                if (methods != null && methods.size() > 0) {
                    this.queryMethod = methods.size() > 1 ? HttpMethod.auto : HttpMethod.fromType(methods.iterator().next().name());
                } else {
                    this.responseType = this.responseBody != null ? ResponseType.JSON : ResponseType.TEXT;
                }
                if (annotations.length == 1 && this.requestType.equals(RequestType.JSON)) {
                    Method[] ctMethods;
                    Class<?> clazz = parameterClasses[0];
                    for (Method method : ctMethods = clazz.getDeclaredMethods()) {
                        if (!method.getName().startsWith("get")) continue;
                        String fileName = method.getName().substring(3, method.getName().length());
                        if (fileName.length() > 0) {
                            fileName = fileName.substring(0, 1).toLowerCase() + fileName.substring(1, fileName.length());
                        } else {
                            System.out.println(method.getName() + method);
                        }
                        this.paramsMap.put(fileName, method.getReturnType().getName());
                    }
                } else {
                    int i;
                    CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
                    if (codeAttribute != null) {
                        int pos;
                        TreeMap<Integer, String> sortMap = new TreeMap<Integer, String>();
                        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
                        int n = pos = Modifier.isStatic((int)ctmethod.getModifiers()) ? 0 : 1;
                        if (attr != null) {
                            for (i = 0; i < attr.tableLength(); ++i) {
                                sortMap.put(attr.index(i), attr.variableName(i));
                                if (attr.index(i) < pos || attr.index(i) >= paramNames.length + pos) continue;
                                paramNames[attr.index((int)i) - pos] = attr.variableName(i);
                            }
                        }
                    }
                    Method sourceMethod = this.getSourceMethod();
                    if (annotations != null && annotations.length > 0) {
                        int k = 0;
                        Object[][] pos = annotations;
                        i = pos.length;
                        for (int method = 0; method < i; ++method) {
                            Object[] annotationTypes;
                            for (Object annotation : annotationTypes = pos[method]) {
                                if (RequestBody.class.isAssignableFrom(annotation.getClass())) {
                                    this.requestType = RequestType.JSON;
                                }
                                if (!PathVariable.class.isAssignableFrom(annotation.getClass()) || paramNames.length <= k) continue;
                                this.pathVariables.put(paramNames[k], (PathVariable)annotation);
                            }
                            ++k;
                        }
                    }
                    Parameter[] parameters = sourceMethod.getParameters();
                    for (int i2 = 0; i2 < paramNames.length; ++i2) {
                        RequestParam paramAnnotation;
                        String paramName = paramNames[i2];
                        Parameter parameter = parameters[i2];
                        if ((paramName == null || paramName.equals("null") || paramName.equals("")) && parameters != null && parameters.length > i2) {
                            paramName = parameters[i2].getName();
                        }
                        if ((paramAnnotation = parameter.getAnnotation(RequestParam.class)) != null) {
                            if (!paramAnnotation.value().equals("")) {
                                paramName = paramAnnotation.value();
                            }
                            if (!paramAnnotation.defaultValue().equals("")) {
                                this.defaultParamsValueMap.put(paramName, paramAnnotation.defaultValue());
                            }
                            if (paramAnnotation.required()) {
                                this.requiredParams.add(paramName);
                            }
                        }
                        HashSet<Annotation> annotationSet = new HashSet<Annotation>();
                        for (Object annotationType : annotations[i2]) {
                            annotationSet.add((Annotation)annotationType);
                        }
                        RequestParamBean paramBean = new RequestParamBean(paramName, annotationSet, parameterTypes[i2], parameterClasses[i2]);
                        this.paramSet.add(paramBean);
                        this.paramsMap.put(paramName, parameterClasses[i2].getName());
                    }
                }
            }
            this.method = this.getSourceMethod();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @JSONField(serialize=false)
    public Method getSourceMethod() throws ClassNotFoundException {
        if (this.method == null) {
            Class clazz = ClassUtility.loadClass(this.getClassName());
            for (Method cmethod : clazz.getDeclaredMethods()) {
                RequestMappingBean cmappingBean;
                RequestMapping cmapping = AnnotationUtil.getMethodAnnotation(cmethod, RequestMapping.class);
                if (cmapping == null || !(cmappingBean = new RequestMappingBean(cmapping)).getValue().equals(this.mappingBean.getValue())) continue;
                if (this.ctmethod != null) {
                    try {
                        if (cmethod.getParameters().length != this.ctmethod.getParameterTypes().length) continue;
                        this.method = cmethod;
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (cmethod.getParameters().length != this.paramSet.size()) continue;
                this.method = cmethod;
            }
            if (this.method == null) {
                for (Method cmethod : clazz.getMethods()) {
                    if (!cmethod.getName().equals(this.getMethodName())) continue;
                    if (this.ctmethod != null) {
                        try {
                            if (cmethod.getParameters().length != this.ctmethod.getParameterTypes().length) continue;
                            this.method = cmethod;
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (cmethod.getParameters().length != this.paramSet.size()) continue;
                    this.method = cmethod;
                }
            }
        }
        return this.method;
    }

    @JSONField(serialize=false)
    public Class getInnerClass() throws ClassNotFoundException {
        Method method = this.getSourceMethod();
        Class clazz = JSONGenUtil.getInnerReturnType(method.getReturnType());
        return clazz;
    }

    public Map<String, Object> getDefaultParamsValueMap() {
        return this.defaultParamsValueMap;
    }

    public void setDefaultParamsValueMap(Map<String, Object> defaultParamsValueMap) {
        this.defaultParamsValueMap = defaultParamsValueMap;
    }

    public Set<String> getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(Set<String> requiredParams) {
        this.requiredParams = requiredParams;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public HttpMethod getQueryMethod() {
        return this.queryMethod;
    }

    public void setQueryMethod(HttpMethod queryMethod) {
        this.queryMethod = queryMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    public MethodChinaName getMethodChinaName() {
        return this.methodChinaName;
    }

    public void setMethodChinaName(MethodChinaName methodChinaName) {
        this.methodChinaName = methodChinaName;
    }

    public RequestMappingBean getMappingBean() {
        return this.mappingBean;
    }

    public void setMappingBean(RequestMappingBean mappingBean) {
        this.mappingBean = mappingBean;
    }

    public String getPathVariable() {
        return this.pathVariable;
    }

    public void setPathVariable(String pathVariable) {
        this.pathVariable = pathVariable;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public ResponseBody getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(ResponseBody responseBody) {
        this.responseBody = responseBody;
    }

    public Map<String, PathVariable> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, PathVariable> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public Set<RequestParamBean> getParamSet() {
        return this.paramSet;
    }

    public void setParamSet(Set<RequestParamBean> paramSet) {
        this.paramSet = paramSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public void setParamsMap(Map<String, String> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public String toString() {
        return this.methodName;
    }
}

