/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.ds.thread.JDSThreadFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RemoteConnectionManager {
    private static final Integer defaultConnectionSize = 1000;
    static Map<String, ExecutorService> connectionMap = new HashMap<String, ExecutorService>();
    static Map<String, ExecutorService> statiConnectionMap = new HashMap<String, ExecutorService>();
    static Map<String, Integer> connectionSize = new HashMap<String, Integer>();

    public static synchronized void initConnection(String serviceId, Integer size) {
        if (size != null && size > 0) {
            connectionSize.put(serviceId, size);
        } else {
            connectionSize.put(serviceId, defaultConnectionSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getStaticConntction(String serviceId) {
        String string = serviceId;
        synchronized (string) {
            ExecutorService service = connectionMap.get(serviceId);
            if (service == null || service.isShutdown()) {
                service = Executors.newSingleThreadScheduledExecutor(new JDSThreadFactory(serviceId));
                connectionMap.put(serviceId, service);
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getConntctionService(String serviceId) {
        String string = serviceId;
        synchronized (string) {
            ExecutorService service = connectionMap.get(serviceId);
            if (service == null || service.isShutdown()) {
                service = connectionSize.get(serviceId) == null ? Executors.newCachedThreadPool(new JDSThreadFactory(serviceId)) : Executors.newScheduledThreadPool(connectionSize.get(serviceId), new JDSThreadFactory(serviceId));
                connectionMap.put(serviceId, service);
            }
            return service;
        }
    }
}

