/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import com.ds.common.util.java.TmpJavaFileObject;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.web.APIConfig;
import com.ds.web.RequestMappingBean;
import com.ds.web.RequestMethodBean;
import com.ds.web.util.JSONGenUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.tools.JavaFileObject;

public class APIConfigFactory {
    Map<CtClass, APIConfig> classMap = new ConcurrentHashMap<CtClass, APIConfig>();
    Map<String, APIConfig> classApiMap = new ConcurrentHashMap<String, APIConfig>();
    private Map<String, RequestMethodBean> apiConfigMap = new ConcurrentHashMap<String, RequestMethodBean>();
    private Map<String, List<APIConfig>> apiConfigPaths = new ConcurrentHashMap<String, List<APIConfig>>();
    private Map<String, Class<?>> allClassMap = new HashMap();
    static APIConfigFactory instance;
    private static final Log logger;
    public static final String THREAD_LOCK = "Thread Lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APIConfigFactory getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new APIConfigFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    APIConfigFactory() {
        this.reload();
    }

    public synchronized void reload() {
        this.classMap.clear();
        this.classApiMap.clear();
        this.apiConfigMap.clear();
        this.allClassMap.putAll(EsbBeanFactory.getInstance().getAllClass());
        Set<Map.Entry<String, Class<?>>> allClass = this.allClassMap.entrySet();
        for (Map.Entry<String, Class<?>> clazzEntry : allClass) {
            Class<?> clazz = clazzEntry.getValue();
            try {
                if (clazz.isInterface()) continue;
                this.getAPIConfig(clazz.getName());
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void reload(String clazzName) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        Map<String, JavaFileObject> fileObjectMap = ClassUtility.getFileObjectMap();
        if (fileObjectMap.containsKey(clazzName)) {
            Set<String> classNameSet = ClassUtility.getFileObjectMap().keySet();
            LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
            nameSet.addAll(classNameSet);
            for (String className : nameSet) {
                if (!className.equals(clazzName) && !className.startsWith(clazzName + "$")) continue;
                TmpJavaFileObject fileObject = (TmpJavaFileObject)fileObjectMap.get(className);
                ByteArrayClassPath path = new ByteArrayClassPath(clazzName, fileObject.getCompiledBytes());
                pool.appendClassPath((ClassPath)path);
            }
            CtClass ct = pool.getCtClass(clazzName);
            if (!ct.isInterface()) {
                this.classMap.remove(ct);
                this.getAPIConfig(ct);
            }
        } else {
            this.getAPIConfig(clazzName);
        }
    }

    public Set<Class<?>> dyReload(Set<Class<?>> allClass) {
        if (allClass != null) {
            for (Class<?> clazz : allClass) {
                try {
                    if (clazz.isInterface()) continue;
                    this.reload(clazz.getName());
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return allClass;
    }

    public APIConfig getAPIConfigByEsbId(String esbbeanId) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        ServiceBean bean = EsbBeanFactory.getInstance().getIdMap().get(esbbeanId);
        return this.getAPIConfig(bean.getClazz());
    }

    public void clear(String url) {
        String localPath = this.formatUrl(url);
        RequestMethodBean bean = this.findMethodBean(localPath);
        if (bean != null) {
            String className = null;
            try {
                className = bean.getSourceMethod().getDeclaringClass().getName();
                Class clazz = JSONGenUtil.getInnerReturnType(bean.getSourceMethod());
                this.getAPIConfig(clazz.getName());
                this.getAPIConfig(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RequestMethodBean getRequestMappingBean(String url) {
        return this.apiConfigMap.get(url);
    }

    private String formatUrl(String url) {
        String localPath;
        if ((url = StringUtility.replace(url, "//", "/")).indexOf("/") == -1) {
            url = StringUtility.replace(url, ".", "/");
        }
        if (!(localPath = url).startsWith("/")) {
            localPath = "/" + localPath;
        }
        return localPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestMethodBean findMethodBean(String url) {
        String localPath = this.formatUrl(url);
        RequestMethodBean methodBean = this.apiConfigMap.get(localPath);
        String string = localPath;
        synchronized (string) {
            String methodUrl = "";
            if (methodBean == null) {
                LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
                Set<String> keySet = this.apiConfigMap.keySet();
                nameSet.addAll(keySet);
                Iterator iterator = nameSet.iterator();
                while (iterator.hasNext()) {
                    Pattern p;
                    Matcher matcher;
                    String key;
                    String configUrl = key = (String)iterator.next();
                    while (configUrl.indexOf("{") > -1 && configUrl.indexOf("}") > -1) {
                        int start = configUrl.indexOf("{");
                        int end = configUrl.indexOf("}");
                        configUrl = StringUtility.replace(configUrl, configUrl.substring(start, end + 1), ".*?");
                    }
                    if (!configUrl.endsWith("?")) {
                        configUrl = configUrl + "$";
                    }
                    if (!(matcher = (p = Pattern.compile(configUrl, 2)).matcher(localPath)).find() || key.length() <= methodUrl.length()) continue;
                    methodBean = this.apiConfigMap.get(key);
                }
            }
        }
        return methodBean;
    }

    public APIConfig getAPIConfig(String clazzName) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        APIConfig config = null;
        Map<String, JavaFileObject> fileObjectMap = ClassUtility.getFileObjectMap();
        if (fileObjectMap.containsKey(clazzName)) {
            Set<String> classNameSet = ClassUtility.getFileObjectMap().keySet();
            LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
            nameSet.addAll(classNameSet);
            for (String className : nameSet) {
                if (!className.equals(clazzName) && !className.startsWith(clazzName + "$")) continue;
                TmpJavaFileObject fileObject = (TmpJavaFileObject)fileObjectMap.get(className);
                ByteArrayClassPath path = new ByteArrayClassPath(clazzName, fileObject.getCompiledBytes());
                pool.appendClassPath((ClassPath)path);
            }
            CtClass ct = pool.getCtClass(clazzName);
            config = this.getAPIConfig(ct);
        } else {
            config = this.classApiMap.get(clazzName);
            if (config == null) {
                CtClass ct = pool.getCtClass(clazzName);
                config = this.getAPIConfig(ct);
                this.classApiMap.put(clazzName, config);
                List<APIConfig> configs = this.getAPIConfigs(config.getUrl());
                if (!configs.contains(config)) {
                    configs.add(config);
                }
            }
        }
        return config;
    }

    public List<APIConfig> getAPIConfigs(String url) {
        List<APIConfig> configs = this.apiConfigPaths.get(url);
        if (configs == null) {
            configs = new ArrayList<APIConfig>();
            this.apiConfigPaths.put(url, configs);
        }
        return configs;
    }

    public APIConfig getAPIConfig(CtClass clazz) {
        APIConfig config = this.classMap.get(clazz);
        if (config == null) {
            try {
                config = new APIConfig(clazz);
                for (RequestMethodBean bean : config.getMethods()) {
                    if (bean.getUrl() == null) continue;
                    if (this.apiConfigMap.get(bean.getUrl()) != null && !this.apiConfigMap.get(bean.getUrl()).getClassName().equals(bean.getClassName())) {
                        logger.error("url[" + bean.getUrl() + "] error");
                        logger.error("error info fristUlr:[" + this.apiConfigMap.get(bean.getUrl()).getClassName() + ":" + this.apiConfigMap.get(bean.getUrl()).getName() + "]===>  lastUrl[" + bean.getClassName() + ":" + bean.getName() + "]");
                        continue;
                    }
                    this.apiConfigMap.put(bean.getUrl(), bean);
                }
            }
            catch (Throwable e) {
                logger.error("class APIConfig [" + clazz.getName() + "] error");
                e.printStackTrace();
            }
            if (!clazz.isInterface()) {
                try {
                    for (CtClass iclazz : clazz.getInterfaces()) {
                        if (!this.allClassMap.containsKey(iclazz.getName())) continue;
                        this.classMap.put(iclazz, config);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.classMap.put(clazz, config);
        }
        return config;
    }

    public synchronized RequestMappingBean getMapping(Method method, CtClass parentClass) throws SecurityException, NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        APIConfig config = this.getAPIConfig(parentClass);
        Class<?>[] clazzs = method.getParameterTypes();
        CtClass[] ctClazz = new CtClass[clazzs.length];
        for (int k = 0; k < clazzs.length; ++k) {
            ctClazz[k] = pool.get(clazzs[k].getName());
        }
        CtMethod pmethod = parentClass.getDeclaredMethod(method.getName(), ctClazz);
        RequestMappingBean mapping = config.getMethodMap().get(pmethod).getMappingBean();
        return mapping;
    }

    static {
        logger = LogFactory.getLog("JDS", APIConfigFactory.class);
    }
}

