/*
 * Decompiled with CFR 0.152.
 */
package com.ds.web;

import com.ds.common.util.StringUtility;
import com.ds.enums.db.MethodChinaName;
import com.ds.web.RequestMappingBean;
import com.ds.web.RequestMethodBean;
import com.ds.web.annotation.Aggregation;
import com.ds.web.util.AnnotationUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import org.springframework.web.bind.annotation.RequestMapping;

public class APIConfig {
    MethodChinaName chinaName;
    String className;
    String packageName;
    String url;
    String desc;
    String imageClass;
    String name;
    String domainId;
    List<RequestMethodBean> methods = new ArrayList<RequestMethodBean>();
    Map<CtMethod, RequestMethodBean> methodMap = new HashMap<CtMethod, RequestMethodBean>();
    Set<String> urls = new LinkedHashSet<String>();

    APIConfig(CtClass clazz) throws ClassNotFoundException {
        RequestMapping mapping;
        this.className = clazz.getName();
        this.url = "";
        this.name = clazz.getSimpleName();
        Aggregation aggregation = AnnotationUtil.getClassAnnotation(clazz, Aggregation.class);
        if (aggregation != null && !aggregation.domainId().equals("default")) {
            this.domainId = aggregation.domainId();
        }
        if ((mapping = AnnotationUtil.getClassAnnotation(clazz, RequestMapping.class)) != null) {
            if (mapping.value().length > 0) {
                this.url = mapping.value()[0];
                for (String value : mapping.value()) {
                    this.urls.add(value);
                }
            } else if (mapping.path().length > 0) {
                this.url = mapping.path()[0];
                for (String value : mapping.path()) {
                    this.urls.add(value);
                }
            }
            if (this.url.indexOf("/") > -1) {
                String[] paths = this.url.split("/");
                this.packageName = "";
                for (int k = 0; k < paths.length; ++k) {
                    this.packageName = this.packageName.equals("") ? paths[k] : this.packageName + "." + paths[k];
                }
            }
        }
        this.chinaName = AnnotationUtil.getClassAnnotation(clazz, MethodChinaName.class);
        if (this.chinaName != null) {
            if (!this.chinaName.cname().equals("")) {
                this.desc = this.chinaName.cname();
            }
            if (!this.chinaName.imageClass().equals("")) {
                this.imageClass = this.chinaName.imageClass();
            }
        } else {
            this.desc = this.name;
        }
        ArrayList<CtMethod> allMethods = new ArrayList<CtMethod>();
        for (CtMethod method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            allMethods.add(method);
        }
        for (CtMethod method : clazz.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().equals(clazz) || method.getDeclaringClass().equals(Object.class)) continue;
            allMethods.add(method);
        }
        for (CtMethod method : allMethods) {
            RequestMapping methodmapping = AnnotationUtil.getMethodAnnotation(method, RequestMapping.class);
            if (methodmapping == null) continue;
            RequestMappingBean mappingBean = new RequestMappingBean(methodmapping, this.getUrl());
            RequestMethodBean requestMethodBean = new RequestMethodBean(method, mappingBean, null);
            Set<String> keys = requestMethodBean.getParamsMap().keySet();
            boolean isVal = true;
            for (String key : keys) {
                if (key != null && !key.equals("null")) continue;
                isVal = false;
            }
            if (!isVal || requestMethodBean.getUrl() == null || requestMethodBean.getUrl().equals("")) continue;
            this.methods.add(requestMethodBean);
            this.methodMap.put(method, requestMethodBean);
        }
    }

    public RequestMethodBean getMethodByName(String methodName) {
        if (methodName.indexOf(".") > -1 && !(methodName = StringUtility.replace(methodName, ".", "/")).startsWith("/")) {
            methodName = "/" + methodName;
        }
        for (RequestMethodBean bean : this.methods) {
            if (!bean.getName().equals(methodName) && !bean.getMethodName().equals(methodName) && !bean.getUrl().endsWith("/" + methodName)) continue;
            return bean;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof APIConfig) {
            return ((APIConfig)obj).getClassName().equals(this.getClassName());
        }
        return super.equals(obj);
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public Set<String> getUrls() {
        return this.urls;
    }

    public void setUrls(Set<String> urls) {
        this.urls = urls;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<CtMethod, RequestMethodBean> getMethodMap() {
        return this.methodMap;
    }

    public void setMethodMap(Map<CtMethod, RequestMethodBean> methodMap) {
        this.methodMap = methodMap;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<RequestMethodBean> getMethods() {
        return this.methods;
    }

    public void setMethods(List<RequestMethodBean> methods) {
        this.methods = methods;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public MethodChinaName getChinaName() {
        return this.chinaName;
    }
}

