/*
 * Decompiled with CFR 0.152.
 */
package com.ds.template;

import com.ds.jds.core.esb.util.ActionContext;
import com.ds.jds.core.esb.util.ValueStack;
import com.ds.template.JDSFreemarkerManager;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JDSFreemarkerResult {
    private static final long serialVersionUID = -3778230771704661631L;
    protected Configuration configuration;
    protected ObjectWrapper wrapper;
    protected JDSFreemarkerManager freemarkerManager;
    private Writer writer;
    protected String location;
    private String pContentType = "text/html";

    public JDSFreemarkerResult() {
        this.freemarkerManager = new JDSFreemarkerManager();
    }

    public JDSFreemarkerResult(String location) {
        this.location = location;
    }

    public void setFreemarkerManager(JDSFreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    public void setContentType(String aContentType) {
        this.pContentType = aContentType;
    }

    public String getContentType() {
        return this.pContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer doExecute(String location, String templatePath) throws IOException, TemplateException {
        TemplateModel model;
        this.location = location;
        this.configuration = this.getConfiguration(templatePath);
        this.wrapper = this.getObjectWrapper();
        this.writer = new StringWriter();
        Template template = this.configuration.getTemplate(location);
        if (this.preTemplateProcess(template, model = this.createModel())) {
            try {
                template.process((Object)model, this.writer);
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(String location, Writer writer, String templatePath) throws IOException, TemplateException {
        TemplateModel model;
        this.location = location;
        this.configuration = this.getConfiguration(templatePath);
        this.wrapper = this.getObjectWrapper();
        Template template = this.configuration.getTemplate(location);
        if (this.preTemplateProcess(template, model = this.createModel())) {
            try {
                template.process((Object)model, writer);
            }
            finally {
                this.postTemplateProcess(template, model);
            }
        }
    }

    protected Configuration getConfiguration(String templatePath) throws TemplateException {
        return this.freemarkerManager.getConfiguration(templatePath);
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.configuration.getObjectWrapper();
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        return null;
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ValueStack stack = ActionContext.getContext().getValueStack();
        return this.freemarkerManager.buildTemplateModel(stack, this.wrapper);
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        Object attrContentType = template.getCustomAttribute("content_type");
        if (attrContentType == null) {
            String encoding;
            String contentType = this.getContentType();
            if (contentType == null) {
                contentType = "text/html";
            }
            if ((encoding = template.getEncoding()) != null) {
                contentType = contentType + "; charset=" + encoding;
            }
        }
        return true;
    }
}

