/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSContext;
import com.ds.context.RunableActionContextImpl;
import com.ds.engine.ConnectionHandle;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;

public class JDSLocalServer {
    static JDSLocalServer instance;
    public static final String THREAD_LOCK = "Thread Lock";
    private static final Log logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JDSLocalServer getInstance() throws JDSException {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new JDSLocalServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void connect(RunableActionContextImpl context) throws JDSException {
        block4: {
            try {
                JDSLocalServer.getInstance().getClient(context);
                JDSClientService client = this.getClient(context);
                String sessionId = context.getSessionId();
                if (sessionId != null) {
                    if (client != null) {
                        ConnectionHandle handle = client.getConnectionHandle();
                        handle.connect(context);
                    }
                    break block4;
                }
                throw new JDSException("sessionId is  null,  place login frist!");
            }
            catch (JDSException e1) {
                logger.info(e1);
                throw new JDSException("sessionId is invalidate  url:[] place login again!");
            }
        }
    }

    public JDSClientService getClient(JDSContext context) throws JDSException {
        JDSSessionFactory factory = new JDSSessionFactory(context);
        String sessionId = context.getSessionId();
        if (sessionId == null) {
            sessionId = (String)context.getParams("JSESSIONID");
        }
        if (sessionId != null) {
            context.getContext().put("JSESSIONID", sessionId);
        }
        String systemCode = JDSServer.getInstance().getCurrServerBean().getId();
        ConfigCode configCode = JDSServer.getInstance().getCurrServerBean().getConfigCode();
        context.getContext().put("SYSID", systemCode);
        JDSClientService appClient = null;
        try {
            appClient = factory.getJDSClientBySessionId(sessionId, configCode);
        }
        catch (JDSException e) {
            logger.error("sessionId is invalidate sessionId=[" + sessionId + "] ieee=[+" + context.getParams("ieee") + "] place login again!");
        }
        if (appClient != null) {
            appClient.setContext(context);
        }
        return appClient;
    }

    static {
        logger = LogFactory.getLog("JDS", JDSLocalServer.class);
    }
}

