/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.ReturnType;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.ConnectionHandle;
import com.ds.engine.JDSSessionHandle;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;

public class JDSClientServiceImpl
implements JDSClientService {
    private JDSServer jdsServer;
    private JDSSessionHandle sessionHandle;
    private ConfigCode configCode;
    private ConnectionHandle connecionHandel;
    private ConnectInfo connInfo;
    private JDSContext context;

    JDSClientServiceImpl(JDSSessionHandle sessionHandle, ConfigCode configCode) throws JDSException {
        this.sessionHandle = sessionHandle;
        this.configCode = configCode;
        this.jdsServer = JDSServer.getInstance();
    }

    @Override
    public void connect(ConnectInfo connInfo) throws JDSException {
        this.connInfo = connInfo;
        this.jdsServer.connect(this);
    }

    @Override
    public ConnectionHandle getConnectionHandle() {
        return this.connecionHandel;
    }

    @Override
    public ReturnType disconnect() throws JDSException {
        if (this.sessionHandle != null) {
            this.jdsServer.disconnect(this.sessionHandle);
        }
        this.connInfo = null;
        this.sessionHandle = null;
        return new ReturnType(ReturnType.MAINCODE_SUCCESS);
    }

    @Override
    public ConnectInfo getConnectInfo() {
        return this.connInfo;
    }

    @Override
    public ConfigCode getConfigCode() {
        return this.configCode;
    }

    @Override
    public JDSSessionHandle getSessionHandle() {
        if (this.sessionHandle == null) {
            JDSSessionFactory factory = new JDSSessionFactory(this.getContext());
            this.sessionHandle = factory.getSessionHandle();
        }
        return this.sessionHandle;
    }

    @Override
    public void setConnectionHandle(ConnectionHandle handle) {
        this.connecionHandel = handle;
    }

    @Override
    public JDSContext getContext() {
        if (this.context == null) {
            this.context = JDSActionContext.getActionContext();
        }
        return this.context;
    }

    @Override
    public void setContext(JDSContext context) {
        this.context = context;
    }

    @Override
    public String getSystemCode() {
        return JDSActionContext.getActionContext().getSystemCode();
    }
}

