/*
 * Decompiled with CFR 0.152.
 */
package com.ds.org.conf;

import com.ds.common.CommonConfig;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.CaselessStringKeyHashMap;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.msg.MsgAdapter;
import com.ds.org.conf.OrgConstants;
import com.ds.org.conf.Query;
import com.ds.server.eumus.ConfigCode;
import com.ds.vfs.adapter.FileAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class OrgConfig
implements Serializable {
    private static final String configXMLPath = "org_config.xml";
    private static Map<ConfigCode, OrgConfig> orgConfigMap = new HashMap<ConfigCode, OrgConfig>();
    private Map supportsMap = new CaselessStringKeyHashMap();
    private Map permissionsMap = new CaselessStringKeyHashMap();
    private Map queriesMap = new CaselessStringKeyHashMap();
    private Map fileAdapterMap = new CaselessStringKeyHashMap();
    private Map msgAdapterMap = new CaselessStringKeyHashMap();
    private MsgAdapter msgAdapter;
    private ConfigCode configCode;
    private List<String> serverURLList;
    private Map<String, List<String>> serverPathMap = new HashMap<String, List<String>>();
    private static final Log logger = LogFactory.getLog("JDS", OrgConfig.class);

    protected OrgConfig(ConfigCode configCode) throws JDSException {
        this.loadConfig(configCode);
    }

    public static OrgConfig getInstance() {
        return OrgConfig.getInstance(OrgConstants.CONFIG_KEY);
    }

    public static OrgConfig getInstance(ConfigCode configCode) {
        OrgConfig orgConfig = orgConfigMap.get(configCode);
        if (orgConfig == null) {
            try {
                orgConfig = new OrgConfig(configCode);
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
            if (orgConfig != null) {
                orgConfigMap.put(configCode, orgConfig);
            }
        }
        return orgConfig;
    }

    private void loadConfig(ConfigCode configCode) throws JDSException {
        SAXBuilder builder = new SAXBuilder();
        String orgConfigXMLPath = configXMLPath;
        try {
            Element ee;
            int i;
            List elements;
            if ((configCode == null || configCode.equals(OrgConstants.CONFIG_KEY)) && (orgConfigXMLPath = CommonConfig.getValue((configCode = OrgConstants.CONFIG_KEY).getType() + ".OrgConfigXMLPath")) == null) {
                String subOrgConfigXMLPath = CommonConfig.getValue(OrgConstants.CONFIG_KEY.getType() + ".database.SubOrgConfigXMLPath");
                orgConfigXMLPath = subOrgConfigXMLPath != null ? subOrgConfigXMLPath : configXMLPath;
            }
            Document configDoc = null;
            InputStream is = null;
            File engineConfigFile = new File(JDSConfig.Config.configPath(), orgConfigXMLPath);
            if (engineConfigFile.exists()) {
                try {
                    configDoc = builder.build(engineConfigFile);
                }
                catch (FileNotFoundException e) {
                    logger.error("Org OrgConfig [" + engineConfigFile.getAbsolutePath() + "] load err ");
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
            } else if (new File(JDSConfig.Config.publicConfigPath(), orgConfigXMLPath).exists()) {
                engineConfigFile = new File(JDSConfig.Config.publicConfigPath(), orgConfigXMLPath);
                configDoc = builder.build(engineConfigFile);
            } else {
                is = ClassUtility.loadResource(orgConfigXMLPath);
                if (is != null) {
                    configDoc = builder.build(is);
                } else {
                    logger.error("Org OrgConfig [" + orgConfigXMLPath + "] NotFound ");
                    throw new JDSException("Org OrgConfig [" + orgConfigXMLPath + "] NotFound ");
                }
            }
            Element root = configDoc.getRootElement();
            Element e = root.getChild("Supports");
            if (e != null) {
                elements = e.getChildren();
                for (i = 0; i < elements.size(); ++i) {
                    ee = (Element)elements.get(i);
                    this.supportsMap.put(ee.getAttributeValue("name"), ee.getAttributeValue("value"));
                }
            }
            if ((e = root.getChild("Permissions")) != null) {
                elements = e.getChildren();
                for (i = 0; i < elements.size(); ++i) {
                    ee = (Element)elements.get(i);
                    this.permissionsMap.put(ee.getAttributeValue("name"), ee.getAttributeValue("value"));
                }
            }
            this.fileAdapterMap.clear();
            e = root.getChild("FileAdapter");
            if (e != null) {
                elements = e.getChildren();
                for (i = 0; i < elements.size(); ++i) {
                    ee = (Element)elements.get(i);
                    this.fileAdapterMap.put(ee.getName(), ee.getTextTrim());
                }
            }
            this.fileAdapterMap.put("systemCode", configCode.getType());
            this.msgAdapterMap.clear();
            e = root.getChild("MsgAdapter");
            if (e != null) {
                elements = e.getChildren();
                for (i = 0; i < elements.size(); ++i) {
                    ee = (Element)elements.get(i);
                    this.msgAdapterMap.put(ee.getName(), ee.getTextTrim());
                }
            }
            this.msgAdapterMap.put("systemCode", configCode.getType());
            e = root.getChild("Queries");
            if (e != null) {
                elements = e.getChildren("Query");
                for (i = 0; i < elements.size(); ++i) {
                    ee = (Element)elements.get(i);
                    Query query = new Query();
                    List clauses = ee.getChildren("SqlClause");
                    CaselessStringKeyHashMap sqlClauses = new CaselessStringKeyHashMap();
                    for (int j = 0; j < clauses.size(); ++j) {
                        List columnMappings;
                        Element clause = (Element)clauses.get(j);
                        Query.SqlClause sqlClause = new Query.SqlClause(query);
                        sqlClause.setType(clause.getAttributeValue("type"));
                        String strMainClause = clause.getChildText("MainClause");
                        String topIds = clause.getChildText("topIds");
                        sqlClause.setTopIds(topIds);
                        if (strMainClause == null || strMainClause.equals("")) continue;
                        sqlClause.setMainClause(strMainClause);
                        String strInsertClause = clause.getChildText("InsertClause");
                        sqlClause.setInsertClause(strInsertClause);
                        String strDeleteClause = clause.getChildText("DeleteClause");
                        sqlClause.setDeleteClause(strDeleteClause);
                        sqlClause.setUpdataClause(clause.getChildText("UpdataClause"));
                        sqlClause.setOrderClause(clause.getChildText("OrderClause"));
                        sqlClause.setTableName(clause.getChildText("TableName"));
                        sqlClause.setTopIds(clause.getChildText("TopIds"));
                        String whereClause = clause.getChildText("WhereClause");
                        whereClause = StringUtility.replace(whereClause, "[SYSTEMID]", configCode.getType());
                        sqlClause.setWhereClause(whereClause);
                        if (clause.getChild("ColumnMappings") == null || (columnMappings = clause.getChild("ColumnMappings").getChildren()).size() == 0) continue;
                        CaselessStringKeyHashMap map = new CaselessStringKeyHashMap();
                        for (int k = 0; k < columnMappings.size(); ++k) {
                            Element mapping = (Element)columnMappings.get(k);
                            Query.ColumnMapping colMapping = new Query.ColumnMapping(query);
                            String property = mapping.getAttributeValue("property");
                            colMapping.setProperty(property);
                            String columnAlias = mapping.getAttributeValue("columnAlias");
                            String column = mapping.getAttributeValue("column");
                            if (columnAlias != null && !columnAlias.equals("")) {
                                colMapping.setColumnAlias(columnAlias);
                            } else if (column != null && !column.equals("")) {
                                colMapping.setColumn(column);
                            }
                            if (column != null && !column.equals("")) {
                                colMapping.setColumn(column);
                            } else if (columnAlias != null && !columnAlias.equals("")) {
                                colMapping.setColumn(columnAlias);
                            }
                            map.put(property, colMapping);
                        }
                        sqlClause.setColumnMappings(map);
                        sqlClauses.put(sqlClause.getType(), sqlClause);
                    }
                    query.setType(ee.getAttributeValue("type"));
                    query.setSqlClauses(sqlClauses);
                    this.queriesMap.put(ee.getAttributeValue("type"), query);
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isSupportPersonRole() {
        Object o = this.supportsMap.get("supportPersonRole");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportOrgRole() {
        Object o = this.supportsMap.get("supportOrgRole");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportOrgModule() {
        Object o = this.supportsMap.get("supportOrgModule");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportOrgApp() {
        Object o = this.supportsMap.get("supportOrgApp");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportOrgLevel() {
        Object o = this.supportsMap.get("supportOrgLevel");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonLevel() {
        Object o = this.supportsMap.get("supportPersonLevel");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonDuty() {
        Object o = this.supportsMap.get("supportPersonDuty");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonPosition() {
        Object o = this.supportsMap.get("supportPersonPosition");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonGroup() {
        Object o = this.supportsMap.get("supportPersonGroup");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonPrivateGroup() {
        Object o = this.supportsMap.get("supportPersonPrivateGroup");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportModuleProperty() {
        Object o = this.supportsMap.get("supportModelProperty");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonModuleProperty() {
        Object o = this.supportsMap.get("supportPersonModelProperty");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportDeskTopProperty() {
        Object o = this.supportsMap.get("supportDeskTopProperty");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonMsg() {
        Object o = this.supportsMap.get("supportPersonMsg");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportModule() {
        Object o = this.supportsMap.get("supportModule");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportApp() {
        Object o = this.supportsMap.get("supportApp");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSelfOrgOnly() {
        Object o = this.permissionsMap.get("selfOrgOnly");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportSSO() {
        Object o = this.supportsMap.get("supportSSO");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportVFS() {
        Object o = this.supportsMap.get("supportVFS");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupports(String name) {
        Object o = this.supportsMap.get(name);
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isPermits(String name) {
        Object o = this.permissionsMap.get(name);
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public Query getQuery(String type) {
        return (Query)this.queriesMap.get(type);
    }

    public FileAdapter getFileAdapter() {
        return this.getFileAdapter(null);
    }

    public FileAdapter getFileAdapter(String rootPath) {
        FileAdapter fileAdapter = null;
        if (rootPath == null) {
            rootPath = this.getServerURLList("root").get(0);
        }
        try {
            Class clazz = null;
            if (rootPath.startsWith("smb://")) {
                clazz = ClassUtility.loadClass("com.ds.vfs.store.adapter.SmbFileAdapter");
                fileAdapter = (FileAdapter)clazz.getConstructor(String.class).newInstance(rootPath);
            } else if (rootPath.startsWith("ftp://")) {
                clazz = ClassUtility.loadClass("com.ds.vfs.store.adapter.FTPFileAdapter");
                fileAdapter = (FileAdapter)clazz.getConstructor(String.class).newInstance(rootPath);
            } else if (rootPath.startsWith("hdfs://")) {
                clazz = ClassUtility.loadClass("com.ds.vfs.store.adapter.HdfsFileAdapter");
                fileAdapter = (FileAdapter)clazz.getConstructor(String.class).newInstance(rootPath);
            } else if (rootPath.startsWith("vfs://")) {
                clazz = ClassUtility.loadClass("com.ds.vfs.store.adapter.ClusterFileAdapter");
                fileAdapter = (FileAdapter)clazz.getConstructor(String.class).newInstance(rootPath);
            } else {
                clazz = ClassUtility.loadClass("com.ds.vfs.store.adapter.LocalFileAdapter");
                fileAdapter = (FileAdapter)clazz.getConstructor(String.class).newInstance(rootPath);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return fileAdapter;
    }

    public synchronized List<String> getServerURLList(String path) {
        if (this.serverURLList == null) {
            String serverURL = (String)this.getFileAdapterMap().get("serverURL");
            this.serverURLList = new ArrayList<String>();
            if (serverURL.split(",").length > 1) {
                String[] usls;
                for (String url : usls = serverURL.split(",")) {
                    this.serverURLList.add(url);
                    this.serverPathMap.put(url, new ArrayList());
                }
            } else {
                this.serverURLList.add(serverURL);
                this.serverPathMap.put(serverURL, new ArrayList());
            }
        }
        Collections.sort(this.serverURLList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String server1 = (String)o1;
                String server2 = (String)o2;
                if (!OrgConfig.this.getFileAdapter().testConnection(server1)) {
                    return -1;
                }
                if (((List)OrgConfig.this.serverPathMap.get(server1)).size() < ((List)OrgConfig.this.serverPathMap.get(server2)).size()) {
                    return -1;
                }
                return 1;
            }
        });
        this.serverPathMap.get(this.serverURLList.get(0)).add(path);
        return this.serverURLList;
    }

    public MsgAdapter getMsgdapter() {
        Class[] parameter = null;
        Object[] objs = null;
        if (this.msgAdapter == null) {
            try {
                String className = (String)this.msgAdapterMap.get("className");
                String serverUrl = (String)this.msgAdapterMap.get("serverUrl");
                if (className != null && serverUrl != null) {
                    Integer threadPoolSize = Integer.parseInt((String)this.msgAdapterMap.get("threadPoolSize"));
                    if (serverUrl == null || serverUrl.equals("")) {
                        parameter = new Class[]{String.class, Integer.class};
                        objs = new Object[]{this.configCode.getType(), threadPoolSize};
                    } else {
                        parameter = new Class[]{String.class, String.class, Integer.class};
                        objs = new Object[]{this.configCode.getType(), serverUrl, threadPoolSize};
                    }
                    Constructor constructor = ClassUtility.loadClass(className).getConstructor(parameter);
                    this.msgAdapter = (MsgAdapter)constructor.newInstance(objs);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.msgAdapter;
    }

    public boolean isSupportPerson() {
        Object o = this.supportsMap.get("supportPerson");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public boolean isSupportPersonOrg() {
        Object o = this.supportsMap.get("supportPersonOrg");
        return o != null && o.toString().equalsIgnoreCase("true");
    }

    public Map getFileAdapterMap() {
        return this.fileAdapterMap;
    }

    public static void main(String[] args) {
        System.out.println(OrgConfig.getInstance(null).isSupportPersonRole());
        System.out.println(OrgConfig.getInstance(null).getQuery("Person").getSqlClause("BASIC").getMainClause());
    }
}

