/*
 * Decompiled with CFR 0.152.
 */
package com.ds.org.conf;

import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import java.io.File;

public class ClientConfig {
    public static final String CONFIG_FILENAME = "org_client_config.xml";
    private static XMLProperties properties = null;

    public static String getValue(String name) {
        ClientConfig.init();
        if (properties != null) {
            return properties.getProperty(name);
        }
        return null;
    }

    public void reLoad() {
        properties = null;
        this.init();
    }

    public static String[] getValues(String name) {
        ClientConfig.init();
        if (properties != null) {
            return properties.getProperties(name);
        }
        return new String[0];
    }

    public static void setValue(String name, String value) {
        ClientConfig.init();
        if (properties != null) {
            try {
                properties.setProperty(name, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void init() {
        if (properties == null) {
            String path;
            File engineConfigFile = new File(JDSConfig.Config.configPath(), CONFIG_FILENAME);
            if (!engineConfigFile.exists()) {
                path = JDSConfig.getAbsolutePath(File.separator);
                engineConfigFile = new File(JDSConfig.Config.publicConfigPath(), CONFIG_FILENAME);
            }
            if (!engineConfigFile.exists()) {
                path = JDSConfig.getAbsolutePath(File.separator);
                engineConfigFile = new File(path, CONFIG_FILENAME);
            }
            if (engineConfigFile.exists()) {
                properties = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
            }
        }
    }
}

