/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class TextUtils {
    public static final String htmlEncode(String s) {
        return TextUtils.htmlEncode(s, true);
    }

    public static final String htmlEncode(String s, boolean encodeSpecialChars) {
        s = TextUtils.noNull(s);
        StringBuffer str = new StringBuffer();
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            if (encodeSpecialChars && c < '\u00ff') {
                String hexChars = "0123456789ABCDEF";
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x" + hex + ";");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static final String join(String glue, Iterator pieces) {
        StringBuffer s = new StringBuffer();
        while (pieces.hasNext()) {
            s.append(pieces.next().toString());
            if (!pieces.hasNext()) continue;
            s.append(glue);
        }
        return s.toString();
    }

    public static final String join(String glue, String[] pieces) {
        return TextUtils.join(glue, Arrays.asList(pieces).iterator());
    }

    public static final String join(String glue, Collection pieces) {
        return TextUtils.join(glue, pieces.iterator());
    }

    public static final String noNull(String string, String defaultString) {
        return TextUtils.stringSet(string) ? string : defaultString;
    }

    public static final String noNull(String string) {
        return TextUtils.noNull(string, "");
    }

    public static final boolean stringSet(String string) {
        return string != null && !"".equals(string);
    }

    public static final boolean verifyUrl(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("https://")) {
            url = "http://" + url.substring(8);
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

