/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import com.ds.common.util.ClassUtility;
import com.ds.jds.core.esb.util.CompoundRoot;
import com.ds.jds.core.esb.util.FileManager;
import com.ds.jds.core.esb.util.JDSBasicConverter;
import com.ds.jds.core.esb.util.ObjectFactory;
import com.ds.jds.core.esb.util.ObjectTypeDeterminer;
import com.ds.jds.core.esb.util.ObjectTypeDeterminerFactory;
import com.ds.jds.core.esb.util.ValueStack;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import ognl.DefaultTypeConverter;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDSConverter
extends DefaultTypeConverter {
    private static JDSConverter instance;
    protected static final Log LOG;
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    public static final String LAST_BEAN_CLASS_ACCESSED = "last.bean.accessed";
    public static final String LAST_BEAN_PROPERTY_ACCESSED = "last.property.accessed";
    protected HashMap<String, Map<String, Object>> mappings = new HashMap();
    protected LinkedHashSet<String> noMapping = new LinkedHashSet();
    protected HashMap<String, TypeConverter> defaultMappings = new HashMap();
    protected LinkedHashSet<String> unknownMappings = new LinkedHashSet();
    protected TypeConverter defaultTypeConverter = new JDSBasicConverter();
    protected ObjectTypeDeterminer objectTypeDeterminer = null;

    protected JDSConverter() {
        try {
            this.loadConversionProperties("jdsesd-default-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loadConversionProperties("jdsesd-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConversionErrorMessage(String propertyName, ValueStack stack) {
        String message = (String)stack.findValue(propertyName);
        return message;
    }

    public static JDSConverter getInstance() {
        if (instance == null) {
            instance = new JDSConverter();
        }
        return instance;
    }

    public static void setInstance(JDSConverter instance) {
        JDSConverter.instance = instance;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        String resource = className.replace('.', '/') + "-conversion.properties";
        return resource;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setDefaultConverter(TypeConverter defaultTypeConverter) {
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map map, Object o, Class aClass) {
        return this.convertValue(map, null, null, null, o, aClass);
    }

    public Object convertValue(Map context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (value != null && toClass == value.getClass()) {
            return value;
        }
        if (target != null) {
            Class clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            tc = (TypeConverter)this.getConverter(clazz, property);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("field-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc)));
            }
        }
        if (tc == null && context != null) {
            Object lastPropertyPath = context.get("current.property.path");
            Class clazz = (Class)context.get(LAST_BEAN_CLASS_ACCESSED);
            if (lastPropertyPath != null && clazz != null) {
                String path = lastPropertyPath + "." + property;
                tc = (TypeConverter)this.getConverter(clazz, path);
            }
        }
        if (tc == null) {
            tc = toClass.equals(String.class) && value != null && !value.getClass().equals(String.class) && !value.getClass().equals(String[].class) ? this.lookup(value.getClass()) : this.lookup(toClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("global-level type converter for property [" + property + "] = " + (tc == null ? "none found" : tc)));
            }
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("falling back to default type converter [" + this.defaultTypeConverter + "]"));
                }
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return OgnlRuntime.NoConversionPossible;
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"falling back to Ognl's default type conversion");
            }
            return super.convertValue(context, target, member, property, value, toClass);
        }
        catch (Exception e) {
            this.handleConversionException(context, property, value, target);
            return OgnlRuntime.NoConversionPossible;
        }
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className)) {
            return null;
        }
        TypeConverter result = this.defaultMappings.get(className);
        if (result == null) {
            Class clazz = null;
            try {
                clazz = ClassUtility.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Property: " + property));
            LOG.debug((Object)("Class: " + clazz.getName()));
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            if (property != null && !this.noMapping.contains(clazz.getName())) {
                try {
                    Map<String, Object> mapping = this.mappings.get(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    Object converter = mapping.get(property);
                    if (LOG.isDebugEnabled() && converter == null) {
                        LOG.debug((Object)("converter is null for property " + property + ". Mapping size: " + mapping.size()));
                        for (String next : mapping.keySet()) {
                            LOG.debug((Object)(next + ":" + mapping.get(next)));
                        }
                    }
                    return converter;
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz.getName());
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map context, String property, Object value, Object object) {
        if (Boolean.TRUE.equals(context.get(REPORT_CONVERSION_ERRORS))) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.ds.jds.core.esb.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.ds.jds.core.esb.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    public synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
    }

    public synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    private Object[] getClassProperty(Map context) {
        return (Object[])context.get("__link");
    }

    private Object acceptableErrorValue(Class toClass) {
        if (!toClass.isPrimitive()) {
            return null;
        }
        if (toClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (toClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (toClass == Long.TYPE) {
            return new Long(0L);
        }
        if (toClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toClass == Short.TYPE) {
            return new Short(0);
        }
        if (toClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (toClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    void addConverterMapping(Map<String, Object> mapping, Class clazz) {
        try {
            String converterFilename = JDSConverter.buildConverterFilename(clazz);
            InputStream is = FileManager.loadFile(converterFilename, clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("processing conversion file [" + converterFilename + "] [class=" + clazz + "]"));
                }
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> it = prop.entrySet().iterator();
                while (it.hasNext() && !mapping.containsKey(key = (String)(entry = it.next()).getKey())) {
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("\t" + key + ":" + entry.getValue() + "[treated as String]"));
                        }
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith(CONVERSION_COLLECTION_PREFIX))) {
                        TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]"));
                        }
                        mapping.put(key, _typeConverter);
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]"));
                            }
                            mapping.put(key, _typeConverter);
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("\t" + key + ":" + entry.getValue() + "[treated as Class " + converterClass + "]"));
                        }
                        mapping.put(key, converterClass);
                        continue;
                    }
                    Class<?> _c = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("\t" + key + ":" + entry.getValue() + "[treated as Class " + _c + "]"));
                    }
                    mapping.put(key, _c);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Problem loading properties for " + clazz.getName()), (Throwable)ex);
        }
    }

    private Map<String, Object> buildConverterMapping(Class clazz) throws Exception {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Class curClazz = clazz;
        while (!curClazz.equals(Object.class)) {
            this.addConverterMapping(mapping, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int x = 0; x < interfaces.length; ++x) {
                this.addConverterMapping(mapping, interfaces[x]);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.mappings.put(clazz.getName(), mapping);
        } else {
            this.noMapping.add(clazz.getName());
        }
        return mapping;
    }

    private Map<String, Object> conditionalReload(Class clazz, Map<String, Object> oldValues) throws Exception {
        Map<String, Object> mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading(JDSConverter.buildConverterFilename(clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    TypeConverter createTypeConverter(String className) throws Exception {
        return (TypeConverter)ObjectFactory.getObjectFactory().buildBean(ClassUtility.loadClass(className), null);
    }

    public void loadConversionProperties(String propsName) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsName);
        Properties props = new Properties();
        props.load(is);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processing conversion file [" + propsName + "]"));
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            try {
                TypeConverter _typeConverter = this.createTypeConverter((String)entry.getValue());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("\t" + key + ":" + entry.getValue() + " [treated as TypeConverter " + _typeConverter + "]"));
                }
                this.defaultMappings.put(key, _typeConverter);
            }
            catch (Exception e) {
                LOG.error((Object)"Conversion registration error", (Throwable)e);
            }
        }
    }

    TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = this.defaultMappings.get(clazz.getName())) == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!this.defaultMappings.containsKey(interfaces[i].getName())) continue;
                result = this.defaultMappings.get(interfaces[i].getName());
                break;
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }

    public ObjectTypeDeterminer getObjectTypeDeterminer() {
        if (this.objectTypeDeterminer == null) {
            return ObjectTypeDeterminerFactory.getInstance();
        }
        return this.objectTypeDeterminer;
    }

    public void setObjectTypeDeterminer(ObjectTypeDeterminer determiner) {
        this.objectTypeDeterminer = determiner;
    }

    static {
        LOG = LogFactory.getLog(JDSConverter.class);
    }
}

