/*
 * Decompiled with CFR 0.152.
 */
package com.ds.jds.core.esb.util;

import com.ds.common.util.IOUtility;
import com.ds.thread.JDSThreadFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.CharsetUtils;

public class DownLoadPageTask {
    static ExecutorService threadpool = Executors.newFixedThreadPool(100, new JDSThreadFactory("DownLoadPageTask.threadpool"));
    Async async = Async.newInstance().use((Executor)threadpool);
    static DownLoadPageTask task;

    public static DownLoadPageTask getInstance() {
        if (task == null) {
            task = new DownLoadPageTask();
        }
        return task;
    }

    public Future<Content> getFuture(String url, final File file) {
        Request request = Request.Get((String)url);
        Future future = this.async.execute(request, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
            }

            public void completed(Content content) {
                try {
                    DownLoadPageTask.this.copyStreamToFile(content.asStream(), file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void cancelled() {
            }
        });
        return future;
    }

    public void shutdown() {
        threadpool.shutdown();
    }

    private void copyStreamToFile(InputStream input, File file) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String message = "Unable to open file " + file + " for writing.";
            throw new IOException(message);
        }
        FileOutputStream output = new FileOutputStream(file);
        IOUtility.copy(input, (OutputStream)output);
        IOUtility.shutdownStream(input);
        IOUtility.shutdownStream(output);
    }

    public static void main(String[] args) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        CloseableHttpResponse httpResponse = null;
        String localFilePath = "C:\\Users\\wenzhang\\workspace\\bsisoft\\itjds\\vfs\\net\\itjds\\vfs\\Folder.java";
        File localFile = new File(localFilePath);
        FileBody fileBody = new FileBody(localFile);
        try {
            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("Image_card", (ContentBody)fileBody).setCharset(CharsetUtils.get((String)"UTF-8")).build();
            HttpPost httpPost = new HttpPost("http://smart.fvt.tjia.com/UploadServlet");
            httpPost.setEntity(reqEntity);
            httpResponse = (CloseableHttpResponse)httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

